package storeroom.draw;

import java.awt.Color;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicButtonUI;

import storeroom.util.SwingResourceManager;

public class Draw {

	public static final String sPath = "/storeroom/draw/";
	/** page */
	public static final String multiIcon = sPath + "pageMulti";
	public static final String singleIcon = sPath + "pageSingle";
	public static final String chartIcon = sPath + "pageChart";

	/** control btn */
	public static final String relIcon = sPath + "btn_bt";
	public static final String dutyIcon = sPath + "btn_duty";
	public static final String dutyIcon2 = sPath + "btn_duty2";
	public static final String holdIcon = sPath + "btn_hold";
	public static final String holdIcon2 = sPath + "btn_hold2";
	public static final String maxIcon = sPath + "btn_max";
	public static final String rangeIcon = sPath + "btn_range";
	public static final String selectIcon = sPath + "btn_sel";
	/** func btn */
	public static final String addIcon = sPath + "func_add";
	public static final String moreIcon = sPath + "func_more";
	public static final String aboutIcon = sPath + "func_info";
	public static final String readIcon = sPath + "func_offlineRead";
	public static final String setIcon = sPath + "func_offlineSet";
	/** sigle multi btn */
	public static final String btIcon = sPath + "listItem_bt";
	public static final String delIcon = sPath + "listItem_delete";

	/** chart btn */
	// public static final String chartSetIcon = sPath + "chart_set";

	public static final Color chartBg = new Color(202, 202, 202);
	public static final Color PlatBg = new Color(238, 238, 238);
	public static final Color lightBlueBg = new Color(163, 223, 243);
	public static final Color darkBlueBg = new Color(103, 203, 236);

	public Draw() {
	}

	public static JButton createIconBtn(Class clazz, String path) {
		Icon orgin = SwingResourceManager.getIcon(clazz, path + ".png");
		Icon press = SwingResourceManager.getIcon(clazz, path + "_.png");
		JButton btn = new JButton();
		btn.setOpaque(false);
		btn.setUI(new BasicButtonUI());
		btn.setBorder(null);
		btn.setIcon(orgin);
		btn.setPressedIcon(press);

		return btn;
	}

	public static JButton createRolloverBtn(Class clazz, String orginPath,
			String rollPath) {
		Icon orgin = SwingResourceManager.getIcon(clazz, orginPath + ".png");
		Icon roll = SwingResourceManager.getIcon(clazz, rollPath + ".png");
		JButton btn = new JButton();
		btn.setOpaque(false);
		btn.setUI(new BasicButtonUI());
		btn.setBorder(null);
		btn.setIcon(orgin);
		btn.setRolloverIcon(roll);

		return btn;
	}

	public static JButton createBtn(Class clazz, String path) {
		Icon orgin = SwingResourceManager.getIcon(clazz, path + ".png");
		JButton btn = new JButton();
		btn.setOpaque(false);
		btn.setUI(new BasicButtonUI());
		btn.setBorder(null);
		btn.setIcon(orgin);

		return btn;
	}
}
