package model.offlineRec;

import java.io.File;
import java.nio.ByteBuffer;

import model.MultimeterClient;

public class OfflineDataModelTest {

	String TAG = "OfflineDataModel";
	byte[] offlineBuffer;

	private File savedFile;
	private String savedFileName = "";

	public OfflineDataModelTest() {
	}

	int markCount = 0;
	boolean status = false, onMark = false, onGetting = false;

	int readbytescount = 0;

	public void collectFlashData(MultimeterClient client, byte[] data,
			int datalength) {
		if (client == null || data == null || datalength <= 0) {
			// MSG_ERROR("handleReceivedData, Invalid argument");
			return;
		}

		for (int i = 0; i < data.length; i++) {
			status = onGetting;
			onMark = (data[i] & 0xff) == 0xff;
			if (onMark && !onGetting) {
				markCount++;
				onGetting = markCount >= 20;
			} else if (onGetting && onMark) {
				markCount--;
				onGetting = markCount <= 0;
			}

			if (onGetting) {// && !onMark
				readbytescount++;
				System.err.print(",(" + readbytescount + ")"
						+ String.format("%02X", data[i]));
				if (readbytescount % 2 == 0)
					System.err.println();

				ByteBuffer buffer;
				int validlength = datalength - i;
				if (offlineBuffer == null) {
					buffer = ByteBuffer.allocate(validlength);
				} else {
					buffer = ByteBuffer.allocate(offlineBuffer.length
							+ validlength);
					buffer.put(offlineBuffer);
				}
				buffer.put(data, i, validlength);

				offlineBuffer = buffer.array();

			}

			if (status && !onGetting) {
				System.err
						.println("111.Flash data transmit over ,send broadcast to saveData");
				client.setTransmitState(MultimeterClient.STATE_TRANSMIT_REAL_TIME);
				// LenPt = 0;
				// Intent intent = new
				// Intent(SPool.ACTION_READ_PROGRESS_END_TOSAVE);
				// mContext.sendBroadcast(intent);
				savedFile = saveFlashReceivedData(savedFileName);
				handleFlashData(offlineBuffer);

				offlineBuffer = null;
				return;
			}
		}
	}

	void handleFlashData(byte[] data) {
		System.err.println("*************handleFlashData.size:" + data.length);
		for (int i = 0; i < data.length; i++) {
			System.err.print(",(" + i + ")" + String.format("%02X", data[i]));
			if (i % 2 == 0)
				System.err.println();
		}

	}

	public File saveFlashReceivedData(String fileName) {
		return null;
	}

	void MSG_INFO(String msg) {
		// Log.i(TAG, "[ " + TAG + " ] $$$:: " + msg);
		System.out.println("info:" + msg);
	}
}
