package model.chartModel;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

import storeroom.draw.Draw;

public class CreateJChartLine implements ActionListener {

	// javax.swing.Timer t = new javax.swing.Timer(300, this);
	// int time = 0;

	ChartPanel chart;
	XYSeriesCollection dataset;
	final String xTitle = "Index", yTitle = "value";
	JFreeChart freeChart;

	public CreateJChartLine() {

		XYSeriesCollection dataset = getDataset();
		freeChart = createChart(dataset);
		chart = new ChartPanel(freeChart);
		chart.setOpaque(false);

	}

	public ChartPanel getChartPanel() {
		return chart;
	}

	// 根据CategoryDataset创建JFreeChart对象
	public JFreeChart createChart(XYSeriesCollection categoryDataset) {
		JFreeChart jfreechart = ChartFactory.createXYLineChart(null, xTitle,
				yTitle, categoryDataset, PlotOrientation.VERTICAL, true, false,
				false);
		jfreechart.setAntiAlias(false);
		jfreechart.setBackgroundPaint(Draw.PlatBg);

		/** 使用CategoryPlot设置各种参数。以下设置可以省略。 */
		XYPlot plot = jfreechart.getXYPlot();
		plot.setBackgroundAlpha(0.8f);
		plot.setForegroundAlpha(0.8f);
		Font font = new Font("宋体", Font.PLAIN, 12);
		// 图例
		LegendTitle lg = jfreechart.getLegend();
		lg.setPosition(RectangleEdge.TOP);
		lg.setItemFont(font);

		ValueAxis x_axis = plot.getDomainAxis();
		x_axis.setAutoTickUnitSelection(true);
		// x_axis.setLabelFont(font);
		// x_axis.setTickLabelFont(font);
		
		ValueAxis y_axis = plot.getRangeAxis();
		// y_axis.setLabelFont(font);

		// CategoryAxis domainAxis = plot.getDomainAxis();
		// domainAxis.setLabelFont(new Font("宋书", Font.PLAIN, 15)); // 设置横轴字体
		// domainAxis.setTickLabelFont(new Font("宋书", Font.PLAIN, 15));//
		// 设置坐标轴标尺值字体
		// domainAxis.setLowerMargin(0.01);// 左边距 边框距离
		// domainAxis.setUpperMargin(0.06);// 右边距 边框距离,防止最后边的一个数据靠近了坐标轴。
		// domainAxis.setMaximumCategoryLabelLines(10);
		// domainAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
		//
		// // 设置Y轴
		// NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
		// rangeAxis.setLabelFont(new Font("宋书", Font.PLAIN, 15));
		// rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());//
		// Y轴显示整数
		// rangeAxis.setAutoRangeMinimumSize(1); // 最小跨度
		// rangeAxis.setUpperMargin(0.18);// 上边距,防止最大的一个数据靠近了坐标轴。
		// rangeAxis.setLowerBound(0); // 最小值显示0
		// rangeAxis.setAutoRange(false); // 不自动分配Y轴数据
		// rangeAxis.setTickMarkStroke(new BasicStroke(1.6f)); // 设置坐标标记大小
		// rangeAxis.setTickMarkPaint(Color.BLACK); // 设置坐标标记颜色
		// rangeAxis.setTickUnit(new NumberTickUnit(10));// 每10个刻度显示一个刻度值
		return jfreechart;
	}

	public XYSeriesCollection getDataset() {

		// String[] rowKeys = { "One", "Two", "Three" };
		// String[] colKeys = { "1987", "1997", "2007" };
		// double[][] data = { { 50, 20, 30 }, { 20, 10D, 40D },
		// { 40, 30.0008D, 38.24D }, };
		// return DatasetUtilities.createCategoryDataset(rowKeys, colKeys,
		// data);

		// 或者使用类似以下代码
		// DefaultCategoryDataset dataset = new DefaultCategoryDataset();
		// for (int xi = 0; xi < 3; xi++) {
		// dataset.addValue(10, "dev1", String.valueOf(xi));
		// dataset.addValue(5, "dev2", String.valueOf(xi));
		// }
		if (dataset == null)
			dataset = new XYSeriesCollection();

		return dataset;
	}

	public XYSeries createXYSeries(String seriesTitle) {
		XYSeries series = new XYSeries(seriesTitle);
		series.setDescription(seriesTitle);
		dataset.addSeries(series);
		return series;
	}

	public void removeSeries(XYSeries series) {
		dataset.removeSeries(series);
	}

	// 保存为文件
	// public void saveAsFile(JFreeChart chart, String outputPath, int weight,
	// int height) {
	// FileOutputStream out = null;
	// try {
	// File outFile = new File(outputPath);
	// if (!outFile.getParentFile().exists()) {
	// outFile.getParentFile().mkdirs();
	// }
	// out = new FileOutputStream(outputPath);
	// // 保存为PNG
	// ChartUtilities.writeChartAsPNG(out, chart, weight, height);
	// // 保存为JPEG
	// // ChartUtilities.writeChartAsJPEG(out, chart, weight, height);
	// out.flush();
	// } catch (FileNotFoundException e) {
	// e.printStackTrace();
	// } catch (IOException e) {
	// e.printStackTrace();
	// } finally {
	// if (out != null) {
	// try {
	// out.close();
	// } catch (IOException e) {
	// // do nothing
	// }
	// }
	// }
	// }
	public void setXTitle(String s) {
		ValueAxis axis = freeChart.getXYPlot().getDomainAxis();
		axis.setLabel(xTitle + "(" + s + ")");
	}

	public void setYTitle(String s) {
		ValueAxis axis = freeChart.getXYPlot().getRangeAxis();
		axis.setLabel(yTitle + "(" + s + ")");
	}

	public String getYTitle() {
		return freeChart.getXYPlot().getRangeAxis().getLabel();

	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		// dataset.addValue(10, "dev1", String.valueOf(time));
		// series.add(time, Math.random() * 10 + 1020);
		// time++;

	}
}
