package model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import frame.i18n.R;
import frame.i18n.StringRes;

import storeroom.util.DateUtil;
import storeroom.util.FuncUnit;
import storeroom.util.RateUnit;
import storeroom.util.SPool;

import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.offlineRec.OfflineDataModelTest;
import model.offlineRec.OfflineDataModelVariant;

public class MultimeterClient {
	// Debugging
	protected String TAG = "MultimeterClient";
	protected static final boolean Debug = false;
	protected static final boolean Info = true;

	public static final int STATE_DISCONNECTED = 1;
	public static final int STATE_CONNECTING = 2;
	public static final int STATE_CONNECTED = 3;

	public static final int STATE_TRANSMIT_REAL_TIME = 1;
	public static final int STATE_TRANSMIT_FLASH = 2;

	public static final int REASON_CONNECT_SUCCESS = 1;
	public static final int REASON_CONNECT_FAIL = 2;
	public static final int REASON_CONNECTION_LOST = 3;
	public static final int REASON_DEVICE_UNAUTHORIZE = 4;
	public static final int REASON_SWITCH_PAGE = 5;
	public static final int REASON_SERIES_UNAUTHORIZE = 6;

	public static final int ID_VERIFY = 0, READ_DEVICEINFO = 1, WRITE_STARTRECORD = 2, WRITE_READFLASH = 3,
			WRITE_READLEN = 4, WRITE_STOP_RECORD = 5, WRITE_RENAME_CMD = 6;

	protected int mState = STATE_DISCONNECTED;
	protected int mTransmitState = STATE_DISCONNECTED;

	protected String mAddress;
	public boolean needSingleton = false;

	// protected CTimer timer = new CTimer();

	private static int IntervalTime = 0;

	public static void setIntervalTime(int intervalTime) {
		IntervalTime = intervalTime;
	}

	protected List<MultimeterReceivedData> mDataList;

	protected void MSG_DEBUG(String msg) {
		System.out.println(TAG + "#dbg:  " + msg);
	}

	protected void MSG_ERROR(String msg) {
		System.err.println(TAG + "#  " + msg);
	}

	protected void MSG_INFO(String msg) {
		System.out.println(TAG + "#info:" + msg);
	}

	private OfflineDataModelVariant offlineDataModel;
	// OfflineDataModelTest offlineTest;

	protected BleAgent ag;

	public MultimeterClient(String address) {
		mAddress = address;

		mState = STATE_DISCONNECTED;

		mDataList = new ArrayList<MultimeterReceivedData>();
		offlineDataModel = new OfflineDataModelVariant(this);
		// offlineTest = new OfflineDataModelTest();
	}

	public boolean equals(MultimeterClient client) {
		if (mAddress.equals(client.getAddress())) {
			return true;
		} else {
			return false;
		}
	}

	public void setState(int state) {
		MSG_DEBUG("setState, newState = " + state);
		mState = state;
	}

	public int getState() {
		return mState;
	}

	public void setTransmitState(int state) {
		mTransmitState = state;
		switch (state) {
		case STATE_TRANSMIT_FLASH:
			System.out.println("########setTransmitState:FLASH");
			break;
		case STATE_TRANSMIT_REAL_TIME:
			System.out.println("########setTransmitState:REAL_TIME");
			break;

		default:
			break;
		}
	}

	public boolean isOnFlashTransmit() {
		return mTransmitState == STATE_TRANSMIT_FLASH;
	}

	public String getAddress() {
		return mAddress;
	}

	public String getDevName() {
		String DevName = mAddress.replace(":", "_");
		return DevName;
	}

	public List<MultimeterReceivedData> getReceivedData() {
		return mDataList;
	}

	public void clearReceivedData() {
		MSG_DEBUG("clearReceivedData");

		mDataList.clear();

		return;
	}

	public void saveReceivedData() {
		if (mDataList == null || mDataList.size() <= 0)
			return;

		MSG_DEBUG("saveReceivedData, DataSize: " + mDataList.size());

		String date = DateUtil.sf2.format(Calendar.getInstance().getTime());
		String clientString = getDevName();

		MSG_DEBUG("saveReceivedData @ " + clientString + "_" + date.toString() + ".csv");

		try {
			String path = System.getProperty("user.dir");
			File sdCard = new File(path + SPool.OWONPath);
			if (!sdCard.exists()) {
				sdCard.mkdirs();
			}
			File file = new File(sdCard, "(" + clientString + ")_" + date.toString() + ".csv");
			FileOutputStream output = new FileOutputStream(file);
			OutputStreamWriter doutput = new OutputStreamWriter(output, "GBK");// UTF-16
			for (int i = 0; i < mDataList.size(); i++) {
				MultimeterReceivedData data = mDataList.get(i);

				String dataString = new String(i + ",\t" + data.Func + ",\t" + data.ValueString + ",\t" + data.Unit
						+ ",\t" + data.Time + ",\t\t" + data.Date + "\r\n");
				doutput.write(dataString);
				// output.write(dataString.getBytes());
			}
			doutput.close();
			output.close();

		} catch (FileNotFoundException e1) {
			MSG_ERROR("Create file: " + clientString + "_" + date.toString() + ".csv fail");
			return;
		} catch (IOException e2) {
			MSG_ERROR("Write file: " + clientString + "_" + date.toString() + ".csv fail");
			return;
		}

		mDataList.clear();

		return;
	}

	@Override
	public int hashCode() {
		return mAddress.hashCode();
	}

	// public abstract boolean connect();
	//
	// public abstract boolean cwrite(byte[] out);
	//
	// public abstract boolean disconnect();
	//
	// public abstract void sendCommand(int mState, byte[] cmds);
	//
	// protected abstract void close();

	private static final int ONE_DATA_LENGTH = 14;
	private static final int COMMON_ONE_DATA_LENGTH = 6;

	private byte[] mDataLeft;
	private int mDataLeftLength = 0;

	private static final int ERROR_NONE = 0;
	private static final int ERROR_INCORRECT_SIGN_BYTE = 1;
	private static final int ERROR_INCORRECT_SPACE_BYTE = 2;
	private static final int ERROR_INCORRECT_EOF_BYTE = 3;
	private static final int ERROR_INCORRECT_ENTER_BYTE = 4;

	// private void dumpData(byte[] data, int datalength) {
	// try {
	// File file = new File(Environment.getExternalStorageDirectory(),
	// "temp.dat");
	//
	// if (file.exists() == false) {
	// file.createNewFile();
	// }
	//
	// FileOutputStream output = new FileOutputStream(file, true);
	//
	// output.write(data, 0, datalength);
	//
	// output.close();
	// } catch (FileNotFoundException e1) {
	// MSG_ERROR("Create file fail");
	// return;
	// } catch (IOException e2) {
	// MSG_ERROR("Write file fail");
	// return;
	// }
	//
	// return;
	// }

	// private void sendDataBrocast(MultimeterClient client,
	// MultimeterReceivedData receivedData) {
	// Intent intent = new Intent(SPool.ACTION_DATA_RECEIVED);
	//
	// intent.putExtra(SPool.EXTRA_CLIENT, client.getAddress());
	// intent.putExtra(SPool.EXTRA_DATA_INDEX, receivedData.Index);
	// intent.putExtra(SPool.EXTRA_DATA_MODE, receivedData.Mode);
	// intent.putExtra(SPool.EXTRA_DATA_FUNC, receivedData.Func);
	// intent.putExtra(SPool.EXTRA_DATA_VALUESTRING, receivedData.ValueString);
	// intent.putExtra(SPool.EXTRA_DATA_UNIT, receivedData.Unit);
	// intent.putExtra(SPool.EXTRA_DATA_VALUE, receivedData.Value);
	// intent.putExtra(SPool.EXTRA_DATA_TIME, receivedData.Time);
	//
	// mContext.sendBroadcast(intent);
	// }

	// protected void handleReceivedData_B35(MultimeterClient client, byte[]
	// data,
	// int datalength) {
	// if (client == null || data == null || datalength <= 0) {
	// MSG_ERROR("handleReceivedData, Invalid argument");
	// return;
	// }
	//
	// // dumpData(data, datalength);
	//
	// if (client instanceof BluetoothLeClient) {
	// BluetoothDevice device = BluetoothAdapter.getDefaultAdapter()
	// .getRemoteDevice(client.getAddress());
	//
	// } else {
	// }
	//
	// ByteBuffer buffer = ByteBuffer.allocate(mDataLeftLength + datalength);
	//
	// if (mDataLeftLength > 0 && mDataLeft != null) {
	// buffer.put(mDataLeft);
	// }
	// buffer.put(data, 0, datalength);
	//
	// byte[] tmp = buffer.array();
	// int leftlength = mDataLeftLength + datalength;
	//
	// int result = ERROR_NONE;
	//
	// int i = 0;
	//
	// while (leftlength >= ONE_DATA_LENGTH) {
	// boolean negative = false;
	//
	// int data1 = 0, data2 = 0, data3 = 0, data4 = 0;
	//
	// byte sb1 = 0, sb2 = 0, sb3 = 0, sb4 = 0, bar = 0, point = 0;
	//
	// double DATA = 0;
	//
	// String ModeString, FuncString, SignString, DataString, Unit1String,
	// Unit2String;
	//
	// StringBuilder builder = new StringBuilder();
	//
	// if (tmp[i] == 0x2B) {
	// ;
	// } else if (tmp[i] == 0x2D) {
	// negative = true;
	// } else {
	// MSG_ERROR("handleReceivedData, Unexpected sign byte: " + tmp[i]);
	// result = ERROR_INCORRECT_SIGN_BYTE;
	//
	// mDataLeft = null;
	// mDataLeftLength = 0;
	// for (int m = 0, len = tmp.length; m < len; m++) {
	// if (tmp[m] == 0x2B || tmp[m] == 0x2D) {
	// ByteBuffer temp = ByteBuffer.allocate(len - m);
	// temp.put(tmp, m, len - m);
	// mDataLeft = temp.array();
	// mDataLeftLength = len - m;
	//
	// MSG_ERROR("@@@@@handleReceivedData, Resave[" + m + "],"
	// + tmp[m] + "tmplen:" + temp.position());
	// break;
	// }
	// }
	//
	// break;
	// }
	//
	// i++;
	//
	// data1 = tmp[i++];
	// data2 = tmp[i++];
	// data3 = tmp[i++];
	// data4 = tmp[i++];
	//
	// if (tmp[i] != 0x20) {
	// MSG_ERROR("handleReceivedData, Unexpected space byte: "
	// + tmp[i]);
	// result = ERROR_INCORRECT_SPACE_BYTE;
	// mDataLeft = null;// ??验证是否有用
	// mDataLeftLength = 0;
	// break;
	// }
	//
	// i++;
	//
	// point = tmp[i];
	// // builder.append( data1 - 0x30 );
	// // builder.append( data2 - 0x30 );
	// // builder.append( data3 - 0x30 );
	// // builder.append( data4 - 0x30 );
	// // double ohmValue = Double.valueOf(builder.toString());
	// if (tmp[i] == 0x31) {
	// // 0.000
	// DATA = (data1 - 0x30) + (data2 - 0x30) * 0.1 + (data3 - 0x30)
	// * 0.01 + (data4 - 0x30) * 0.001;
	// // ohmValue = ohmValue/1000000;
	// builder.append(data1 - 0x30);
	// builder.append(".");
	// builder.append(data2 - 0x30);
	// builder.append(data3 - 0x30);
	// builder.append(data4 - 0x30);
	// } else if (tmp[i] == 0x32) {
	// // 00.00
	// DATA = (data1 - 0x30) * 10 + (data2 - 0x30) + (data3 - 0x30)
	// * 0.1 + (data4 - 0x30) * 0.01;
	// // ohmValue = ohmValue/1000;
	// builder.append(data1 - 0x30);
	// builder.append(data2 - 0x30);
	// builder.append(".");
	// builder.append(data3 - 0x30);
	// builder.append(data4 - 0x30);
	// } else if (tmp[i] == 0x34) {
	// // 000.0
	// DATA = (data1 - 0x30) * 100 + (data2 - 0x30) * 10
	// + (data3 - 0x30) + (data4 - 0x30) * 0.1;
	// builder.append(data1 - 0x30);
	// builder.append(data2 - 0x30);
	// builder.append(data3 - 0x30);
	// builder.append(".");
	// builder.append(data4 - 0x30);
	// } else {
	// // 0000
	// DATA = (data1 - 0x30) * 1000 + (data2 - 0x30) * 100
	// + (data3 - 0x30) * 10 + (data4 - 0x30);
	// // ohmValue = ohmValue*100;
	// builder.append(data1 - 0x30);
	// builder.append(data2 - 0x30);
	// builder.append(data3 - 0x30);
	// builder.append(data4 - 0x30);
	// }
	// /*
	// * else { MSG_ERROR( "handleReceivedData, Unexpected point byte: " +
	// * tmp[ i ] ); DataString = ""; result = false; break; }
	// */
	// // if(String.valueOf(ohmValue).length()>=7){
	// // DataString = String.valueOf(ohmValue).substring(0, 6);
	// // }else{
	// // DataString = String.valueOf(ohmValue);
	// // }
	// DataString = builder.toString();
	// if (negative == true) {
	// DATA = DATA * -1;
	// SignString = "-";
	// } else {
	// SignString = "";
	// }
	//
	// i++;
	//
	// sb1 = tmp[i++];
	// sb2 = tmp[i++];
	// sb3 = tmp[i++];
	// sb4 = tmp[i++];
	// bar = tmp[i++];
	//
	// if (tmp[i] != 0x0D) {
	// MSG_ERROR("handleReceivedData, Unexpected EOF byte: " + tmp[i]);
	// result = ERROR_INCORRECT_EOF_BYTE;
	// mDataLeft = null;
	// mDataLeftLength = 0;
	// break;
	// }
	// i++;
	//
	// if (tmp[i] != 0x0A) {
	// MSG_ERROR("handleReceivedData, Unexpected ENTER byte: "
	// + tmp[i]);
	// result = ERROR_INCORRECT_ENTER_BYTE;
	// mDataLeft = null;
	// mDataLeftLength = 0;
	// break;
	// }
	// i++;
	//
	// if ((sb1 & BIT_AUTO) != 0 && (sb1 & BIT_HOLD) != 0) {
	// ModeString = "AUTO,H";
	// } else if ((sb1 & BIT_AUTO) != 0) {
	// ModeString = "AUTO";
	// } else if ((sb1 & BIT_REL) != 0) {
	// ModeString = "REL";
	// } else if ((sb1 & BIT_HOLD) != 0) {
	// ModeString = "HOLD";
	// } else if ((sb2 & BIT_MAX) != 0) {
	// ModeString = "MAX";
	// } else if ((sb2 & BIT_MIN) != 0) {
	// ModeString = "MIN";
	// } else if ((sb1 & BIT_AUTO) == 0) {
	// /* MANUAL只能在最后设置，即除了REL、HOLD、MAX、MIN，其他所有状态都设成MANUAL */
	// ModeString = "MANUAL";
	// } else {
	// ModeString = "Null";
	// }
	//
	// FuncString = "Null";
	// if ((sb1 & BIT_DC) != 0) {
	// // FuncString = "DC";
	// if ((sb4 & BIT_VOLT) != 0) {
	// if ((sb3 & BIT_MILLI) != 0) {
	// FuncString = "DCmV";
	// } else {
	// FuncString = "DCV-";
	// }
	// } else if ((sb4 & BIT_AMP) != 0) {
	// if ((sb3 & BIT_MILLI) != 0) {
	// FuncString = "DCmA";
	// } else if ((sb3 & BIT_MICRO) != 0) {
	// FuncString = "DC"
	// + StringRes.getString(R.unit_micro) + "A";
	// } else {
	// FuncString = "DCA-";
	// }
	// }
	//
	// } else if ((sb1 & BIT_AC) != 0) {
	// // FuncString = "AC";
	// if ((sb4 & BIT_VOLT) != 0) {
	// if ((sb3 & BIT_MILLI) != 0) {
	// FuncString = "ACmV";
	// } else {
	// FuncString = "ACV~";
	// }
	// } else if ((sb4 & BIT_AMP) != 0) {
	// if ((sb3 & BIT_MILLI) != 0) {
	// FuncString = "ACmA";
	// } else if ((sb3 & BIT_MICRO) != 0) {
	// FuncString = "AC"
	// + StringRes.getString(R.unit_micro) + "A";
	// } else {
	// FuncString = "ACA~";
	// }
	// }
	// } else if ((sb4 & BIT_AMP) != 0) {
	// // 这一部分是否和DC、AC重复?
	// if ((sb3 & BIT_MILLI) != 0) {
	// FuncString = "CURm";
	// }
	// if ((sb3 & BIT_MICRO) != 0) {
	// FuncString = "CUR"
	// + StringRes.getString(R.unit_micro);
	// } else {
	// FuncString = "CUR";
	// }
	// } else if ((sb4 & BIT_HZ) != 0) {
	// FuncString = "Hz";
	// } else if ((sb4 & BIT_FARAD) != 0) {
	// FuncString = "CAP";
	// } else if ((sb3 & BIT_DIODE) != 0) {
	// FuncString = "DIO";
	// } else if ((sb3 & BIT_BEEP) != 0) {
	// FuncString = "BEEP";
	// } else if ((sb3 & BIT_PERCENT) != 0) {
	// FuncString = "DUT";// "%"
	// } else if ((sb4 & BIT_HFE) != 0) {
	// FuncString = "hFE";
	// } else if ((sb4 & BIT_CENTIGRADE) != 0
	// || (sb4 & BIT_FAHRENHEIT) != 0) {
	// FuncString = "TEMP";
	// } else if ((sb4 & BIT_OHM) != 0) {
	// FuncString = "RES";
	// }
	//
	// else {
	// FuncString = "Null";
	// }
	//
	// if ((sb2 & BIT_NANO) != 0) {
	// Unit1String = StringRes.getString(R.unit_nano);
	// } else if ((sb3 & BIT_MICRO) != 0) {
	// Unit1String = StringRes.getString(R.unit_micro);
	// } else if ((sb3 & BIT_MILLI) != 0) {
	// Unit1String = StringRes.getString(R.unit_milli);
	// } else if ((sb3 & BIT_KILO) != 0) {
	// Unit1String = StringRes.getString(R.unit_kilo);
	// } else if ((sb3 & BIT_MILLION) != 0) {
	// Unit1String = StringRes.getString(R.unit_million);
	// } else {
	// Unit1String = "";
	// }
	//
	// if ((sb4 & BIT_VOLT) != 0) {
	// Unit2String = StringRes.getString(R.unit_volt);
	// } else if ((sb4 & BIT_AMP) != 0) {
	// Unit2String = StringRes.getString(R.unit_ampere);
	// } else if ((sb4 & BIT_OHM) != 0) {
	// Unit2String = StringRes.getString(R.unit_ohm);
	// } else if ((sb4 & BIT_HFE) != 0) {
	// Unit2String = StringRes.getString(R.unit_hFE);
	// } else if ((sb4 & BIT_HZ) != 0) {
	// Unit2String = StringRes.getString(R.unit_Hz);
	// } else if ((sb4 & BIT_FARAD) != 0) {
	// Unit2String = StringRes.getString(R.unit_farad);
	// } else if ((sb4 & BIT_CENTIGRADE) != 0) {
	// Unit2String = StringRes.getString(R.unit_centigrade);
	// } else if ((sb4 & BIT_FAHRENHEIT) != 0) {
	// Unit2String = StringRes.getString(R.unit_fahrenheit);
	// } else if ((sb3 & BIT_PERCENT) != 0) {
	// Unit2String = StringRes.getString(R.unit_percent);
	// } else {
	// Unit2String = "Null";
	// }
	//
	// /** 机器0L在APP上显示为奇怪150.1505的数值，对其做限制处理 */
	// // 欧姆档
	// boolean limit = false;
	// if ((sb4 & BIT_OHM) != 0) {
	// if (point == 0x31) {
	// // 0.000
	// if (DATA > 6) {
	// DATA = 6;
	// limit = true;
	// }
	//
	// } else if (point == 0x32) {
	// // 00.00
	// if (DATA > 60) {
	// DATA = 60;
	// limit = true;
	// }
	//
	// } else if (point == 0x34) {
	// // 000.0
	// if (DATA > 600) {
	// DATA = 600;
	// limit = true;
	// }
	//
	// } else {
	// // 0000
	// if (DATA > 6000) {
	// DATA = 6000;
	// limit = true;
	// }
	//
	// }
	// }
	// // 蜂鸣档
	// if ((sb3 & BIT_BEEP) != 0) {
	// if (DATA > 60) {
	// DATA = 60;
	// limit = true;
	// }
	// }
	//
	// if ((sb3 & BIT_DIODE) != 0) {
	// if (DATA > 6) {
	// DATA = 6;
	// limit = true;
	// }
	// }
	//
	// if (limit) {
	// SignString = "";
	// DataString = "OL";
	// limit = false;
	// }
	// // MSG_ERROR("M:" + ModeString + ",F:" + FuncString + ","
	// // + (SignString + DataString) + ","
	// // + (Unit1String + Unit2String) + ",Value:" + DATA);
	//
	// timer.stop();
	// long tmpt = timer.measure();
	// if (tmpt >= IntervalTime) {
	// timer.start();
	// // System.err.println("IntervalTime:" + (tmpt));
	// MultimeterReceivedData receivedData = new MultimeterReceivedData();
	// ByteBuffer source = ByteBuffer.allocate(ONE_DATA_LENGTH);
	// source.put(tmp, i - ONE_DATA_LENGTH, ONE_DATA_LENGTH);
	// receivedData.SourceData = source.array();
	// receivedData.SourceDataLength = ONE_DATA_LENGTH;
	// receivedData.Index = mDataList.size();
	// receivedData.Mode = ModeString;
	// receivedData.Func = FuncString;
	// receivedData.ValueString = new String(SignString + DataString);
	// receivedData.Unit = new String(Unit1String + Unit2String);
	// receivedData.Value = unifiedUnit(DATA, receivedData.Unit);// DATA;
	//
	// mDataList.add(receivedData);
	// // send
	// sendDataBrocast(client, receivedData);
	// }
	//
	// leftlength -= ONE_DATA_LENGTH;
	//
	// }
	//
	// if (result != ERROR_NONE) {
	// MSG_ERROR("handleReceivedData, Parse received data fail, result = "
	// + result);
	//
	// // Toast.makeText( mContext, "Parse received data fail, result = " +
	// // result, Toast.LENGTH_SHORT ).show();
	//
	// return;
	// }
	//
	// if (leftlength > 0) {
	// // MSG_ERROR("handleReceivedData, " + leftlength + " bytes left");
	//
	// ByteBuffer temp = ByteBuffer.allocate(leftlength);
	//
	// temp.put(tmp, i, leftlength);
	//
	// mDataLeft = temp.array();
	// mDataLeftLength = leftlength;
	// } else {
	// mDataLeft = null;
	// mDataLeftLength = 0;
	// }
	//
	// return;
	// }

	// public String getClientDeviceName() {
	// BluetoothDevice device = BluetoothAdapter.getDefaultAdapter()
	// .getRemoteDevice(this.getAddress());
	// String clientString = PreferenceControl.getDeviceName(mContext,
	// device);// ,this
	// return clientString;
	// }

	private double unifiedUnit(double oValue, String unit) {
		/** 单位统一:电压V,电流mA,电阻kΩ,电容μF,频率kHz */
		// System.out.println("unit:" + unit);
		double v = oValue;

		if (unit.equalsIgnoreCase("mV") || unit.equalsIgnoreCase("μA") || unit.equalsIgnoreCase("Ω")
				|| unit.equalsIgnoreCase("nF") || unit.equalsIgnoreCase("Hz")) {

			BigDecimal df = new BigDecimal(oValue);
			v = df.setScale(5, BigDecimal.ROUND_HALF_DOWN).doubleValue();
		} else if (unit.equalsIgnoreCase("A") || unit.equalsIgnoreCase("MΩ") || unit.equalsIgnoreCase("MHz")) {
			v = oValue * 1000;
		}

		return v;

	}

	// protected void handleReceivedData_B33(MultimeterClient client, byte[]
	// data,
	// int datalength) {
	// if (client == null || data == null || datalength <= 0) {
	// MSG_ERROR("handleReceivedData, Invalid argument");
	// return;
	// }
	//
	// ByteBuffer buffer = ByteBuffer.allocate(mDataLeftLength + datalength
	// + 1);
	// // buffer.put((byte) 0);
	// if (mDataLeftLength > 0 && mDataLeft != null) {
	// buffer.put(mDataLeft);
	// }
	// buffer.put(data, 0, datalength);
	//
	// byte[] buff = buffer.array();
	// int leftlength = mDataLeftLength + datalength;
	//
	// int result = ERROR_NONE;
	//
	// int i = 0;
	// MultimeterDataCell multi = new MultimeterDataCell();
	//
	// // ByteBuffer buffer = ByteBuffer.allocate(datalength + 1);
	// // buffer.put((byte) 0);
	// // buffer.put(data);
	// // int leftlength = datalength;
	// // byte[] buff = buffer.array();
	//
	// while (leftlength >= ONE_DATA_LENGTH) {
	//
	// // //////////////开始解析
	// int i1, i2, i3, i4;
	// boolean negative;
	// double DATA;
	// // int data1 = 0, data2 = 0, data3 = 0, data4 = 0;
	// // byte sb1 = 0, sb2 = 0, sb3 = 0, sb4 = 0, point = 0;// bar = 0,
	// // String SignString = "", DataString = "",
	// String ModeString = "Null", FuncString = "Null", UnitString = "Null";
	// int x = 1;
	// if ((buff[10 - x] & 0x01) != 0) {
	// multi.func_type = multiFunSL_diode;// D
	// FuncString = "DIO";
	//
	// } else if ((buff[1 - x] & 0x04) != 0 && (buff[1 - x] & 0x08) != 0
	// && (buff[13 - x] & 0x04) != 0) {
	// multi.func_type = multiFunSL_acv; // acV
	// FuncString = "ACV~";
	//
	// } else if ((buff[1 - x] & 0x08) != 0 && (buff[13 - x] & 0x04) != 0) {
	// multi.func_type = multiFunSL_acv; // acV
	// FuncString = "ACV~";
	//
	// } else if ((buff[1 - x] & 0x04) != 0 && (buff[13 - x] & 0x04) != 0) {
	// multi.func_type = multiFunSL_dcv; // dcV
	// FuncString = "DCV-";
	//
	// } else if ((buff[1 - x] & 0x04) != 0 && (buff[13 - x] & 0x08) != 0) {
	// multi.func_type = multiFunSL_dca; // dcA
	// FuncString = "DCA-";
	//
	// } else if ((buff[1 - x] & 0x08) != 0 && (buff[13 - x] & 0x08) != 0) {
	// multi.func_type = multiFunSL_aca; // acA
	// FuncString = "ACA~";
	//
	// } else if ((buff[12 - x] & 0x04) != 0 && (buff[11 - x] & 0x01) != 0) {
	// multi.func_type = multiFunSL_rs; // Rs 兆欧
	//
	// } else if ((buff[12 - x] & 0x04) != 0) {
	// multi.func_type = multiFunSL_R; // R 欧
	//
	// } else if ((buff[12 - x] & 0x08) != 0) {
	// multi.func_type = multiFunSL_c; // C F
	// FuncString = "CAP";// FARAD
	//
	// } else {
	// multi.func_type = multiFunSL_reserved;
	// }
	//
	// switch (multi.func_type) {
	// case 1:
	// case 2:
	// case 3:
	// if ((buff[10 - x] & 0x08) != 0) {
	// multi.unit = multiUnit_uV;
	// UnitString = StringRes.getString(R.unit_micro)
	// + StringRes.getString(R.unit_volt);
	// } else if ((buff[11 - x] & 0x08) != 0) {
	// multi.unit = multiUnit_mV;
	// UnitString = StringRes.getString(R.unit_milli)
	// + StringRes.getString(R.unit_volt);
	// } else {
	// multi.unit = multiUnit_V;
	// UnitString = StringRes.getString(R.unit_volt);
	// }
	// break;
	// case 4:
	// if ((buff[10 - x] & 0x08) != 0) {
	// multi.unit = multiUnit_uF;
	// UnitString = StringRes.getString(R.unit_micro)
	// + StringRes.getString(R.unit_farad);
	// } else if ((buff[10 - x] & 0x04) != 0) {
	// multi.unit = multiUnit_nF;
	// UnitString = StringRes.getString(R.unit_nano)
	// + StringRes.getString(R.unit_farad);
	// } else if ((buff[11 - x] & 0x08) != 0) {
	// multi.unit = multiUnit_pF;
	// UnitString = StringRes.getString(R.unit_pico)
	// + StringRes.getString(R.unit_farad);
	// }
	// break;
	// case 5:
	// case 8:
	// if ((buff[10 - x] & 0x02) != 0) {
	// multi.unit = multiUnit_kohm;
	// UnitString = StringRes.getString(R.unit_kilo)
	// + StringRes.getString(R.unit_ohm);
	// } else if ((buff[11 - x] & 0x02) != 0) {
	// multi.unit = multiUnit_Mohm;
	// UnitString = StringRes.getString(R.unit_million)
	// + StringRes.getString(R.unit_ohm);
	// } else {
	// multi.unit = multiUnit_ohm;
	// UnitString = StringRes.getString(R.unit_ohm);
	// }
	// break;
	// case 6:
	// case 7:
	// if ((buff[10 - x] & 0x08) != 0) {
	// multi.unit = multiUnit_uA;
	// UnitString = StringRes.getString(R.unit_micro)
	// + StringRes.getString(R.unit_ampere);
	// } else if ((buff[11 - x] & 0x08) != 0) {
	// multi.unit = multiUnit_mA;
	// UnitString = StringRes.getString(R.unit_milli)
	// + StringRes.getString(R.unit_ampere);
	// } else {
	// multi.unit = multiUnit_A;
	// UnitString = StringRes.getString(R.unit_ampere);
	// }
	// break;
	// default:
	// multi.unit = multiUnit_RESERVED;
	// UnitString = "";
	// }
	//
	// // i = a | b | c | d | e | f | g
	// i4 = (buff[2 - x] & 0x01) | ((buff[3 - x] << 1) & 0x02)
	// | (buff[3 - x] & 0x04) | (buff[3 - x] & 0x08)
	// | ((buff[2 - x] << 2) & 0x10) | ((buff[2 - x] << 4) & 0x20)
	// | ((buff[3 - x] << 5) & 0x40);
	// i3 = (buff[4 - x] & 0x01) | ((buff[5 - x] << 1) & 0x02)
	// | (buff[5 - x] & 0x04) | (buff[5 - x] & 0x08)
	// | ((buff[4 - x] << 2) & 0x10) | ((buff[4 - x] << 4) & 0x20)
	// | ((buff[5 - x] << 5) & 0x40);
	// i2 = (buff[6 - x] & 0x01) | ((buff[7 - x] << 1) & 0x02)
	// | (buff[7 - x] & 0x04) | (buff[7 - x] & 0x08)
	// | ((buff[6 - x] << 2) & 0x10) | ((buff[6 - x] << 4) & 0x20)
	// | ((buff[7 - x] << 5) & 0x40);
	// i1 = (buff[8 - x] & 0x01) | ((buff[9 - x] << 1) & 0x02)
	// | (buff[9 - x] & 0x04) | (buff[9 - x] & 0x08)
	// | ((buff[8 - x] << 2) & 0x10) | ((buff[8 - x] << 4) & 0x20)
	// | ((buff[9 - x] << 5) & 0x40);
	//
	// switch (i4) {
	// case 0x3f:
	// multi.sun4_en = 1;
	// multi.sun4 = 0;
	// break;
	// case 0x06:
	// multi.sun4_en = 1;
	// multi.sun4 = 1;
	// break;
	// case 0x5b:
	// multi.sun4_en = 1;
	// multi.sun4 = 2;
	// break;
	// case 0x4f:
	// multi.sun4_en = 1;
	// multi.sun4 = 3;
	// break;
	// case 0x66:
	// multi.sun4_en = 1;
	// multi.sun4 = 4;
	// break;
	// case 0x6d:
	// multi.sun4_en = 1;
	// multi.sun4 = 5;
	// break;
	// case 0x7d:
	// multi.sun4_en = 1;
	// multi.sun4 = 6;
	// break;
	// case 0x07:
	// multi.sun4_en = 1;
	// multi.sun4 = 7;
	// break;
	// case 0x7f:
	// multi.sun4_en = 1;
	// multi.sun4 = 8;
	// break;
	// case 0x6f:
	// multi.sun4_en = 1;
	// multi.sun4 = 9;
	// break;
	// default:
	// multi.sun4_en = 0;
	// multi.sun4 = 15;
	// }
	//
	// switch (i3) {
	// case 0x3f:
	// multi.sun3_en = 1;
	// multi.sun3 = 0;
	// break;
	// case 0x06:
	// multi.sun3_en = 1;
	// multi.sun3 = 1;
	// break;
	// case 0x5b:
	// multi.sun3_en = 1;
	// multi.sun3 = 2;
	// break;
	// case 0x4f:
	// multi.sun3_en = 1;
	// multi.sun3 = 3;
	// break;
	// case 0x66:
	// multi.sun3_en = 1;
	// multi.sun3 = 4;
	// break;
	// case 0x6d:
	// multi.sun3_en = 1;
	// multi.sun3 = 5;
	// break;
	// case 0x7d:
	// multi.sun3_en = 1;
	// multi.sun3 = 6;
	// break;
	// case 0x07:
	// multi.sun3_en = 1;
	// multi.sun3 = 7;
	// break;
	// case 0x7f:
	// multi.sun3_en = 1;
	// multi.sun3 = 8;
	// break;
	// case 0x6f:
	// multi.sun3_en = 1;
	// multi.sun3 = 9;
	// break;
	// default:
	// multi.sun3_en = 0;
	// multi.sun3 = 15;
	// }
	//
	// switch (i2) {
	// case 0x3f:
	// multi.sun2_en = 1;
	// multi.sun2 = 0;
	// break;
	// case 0x06:
	// multi.sun2_en = 1;
	// multi.sun2 = 1;
	// break;
	// case 0x5b:
	// multi.sun2_en = 1;
	// multi.sun2 = 2;
	// break;
	// case 0x4f:
	// multi.sun2_en = 1;
	// multi.sun2 = 3;
	// break;
	// case 0x66:
	// multi.sun2_en = 1;
	// multi.sun2 = 4;
	// break;
	// case 0x6d:
	// multi.sun2_en = 1;
	// multi.sun2 = 5;
	// break;
	// case 0x7d:
	// multi.sun2_en = 1;
	// multi.sun2 = 6;
	// break;
	// case 0x07:
	// multi.sun2_en = 1;
	// multi.sun2 = 7;
	// break;
	// case 0x7f:
	// multi.sun2_en = 1;
	// multi.sun2 = 8;
	// break;
	// case 0x6f:
	// multi.sun2_en = 1;
	// multi.sun2 = 9;
	// break;
	// default:
	// multi.sun2_en = 0;
	// multi.sun2 = 15;
	// }
	// switch (i1) {
	// case 0x3f:
	// multi.sun1_en = 1;
	// multi.sun1 = 0;
	// break;
	// case 0x06:
	// multi.sun1_en = 1;
	// multi.sun1 = 1;
	// break;
	// case 0x5b:
	// multi.sun1_en = 1;
	// multi.sun1 = 2;
	// break;
	// case 0x4f:
	// multi.sun1_en = 1;
	// multi.sun1 = 3;
	// break;
	// case 0x66:
	// multi.sun1_en = 1;
	// multi.sun1 = 4;
	// break;
	// case 0x6d:
	// multi.sun1_en = 1;
	// multi.sun1 = 5;
	// break;
	// case 0x7d:
	// multi.sun1_en = 1;
	// multi.sun1 = 6;
	// break;
	// case 0x07:
	// multi.sun1_en = 1;
	// multi.sun1 = 7;
	// break;
	// case 0x7f:
	// multi.sun1_en = 1;
	// multi.sun1 = 8;
	// break;
	// case 0x6f:
	// multi.sun1_en = 1;
	// multi.sun1 = 9;
	// break;
	// default:
	// multi.sun1_en = 0;
	// multi.sun1 = 15;
	// }
	// if ((buff[4 - x] & 0x08) != 0) {
	// multi.dot = 1;
	// multi.dot_en = 1;
	// } else if ((buff[6 - x] & 0x08) != 0) {
	// multi.dot = 2;
	// multi.dot_en = 1;
	// } else if ((buff[8 - x] & 0x08) != 0) {
	// multi.dot = 3;
	// multi.dot_en = 1;
	// } else {
	// multi.dot = 0;
	// multi.dot_en = 0;
	// }
	//
	// switch (multi.unit) {
	// case 1: // R
	// case 2:
	// case 3:
	// if (multi.sun1_en != 0 && multi.sun2_en != 0
	// && multi.sun3_en != 0 && multi.sun4_en != 0) {
	// switch (multi.dot) {
	// case 3:
	// multi.data_sum = multi.sun1 * 0.1 + multi.sun2
	// + multi.sun3 * 10 + multi.sun4 * 100; // 400
	// break;
	// case 2:
	// multi.data_sum = multi.sun1 * 0.01 + multi.sun2 * 0.1
	// + multi.sun3 + multi.sun4 * 10; // 40
	// break;
	// case 1:
	// multi.data_sum = multi.sun1 * 0.001 + multi.sun2 * 0.01
	// + multi.sun3 * 0.1 + multi.sun4; // 4
	// break;
	// case 0:
	// multi.data_sum = multi.sun1 + multi.sun2 * 10
	// + multi.sun3 * 100 + multi.sun4 * 1000; // 400
	// break;
	// }
	// } else {
	// multi.data_sum = 8888;
	// }
	//
	// break;
	//
	// case 4: // a
	// case 5:
	// case 6:
	// if (multi.func_type == 7) // DCA
	// {
	// if (multi.sun1_en != 0 && multi.sun2_en != 0
	// && multi.sun3_en != 0 && multi.sun4_en != 0) {
	// switch (multi.dot) {
	// case 3:
	// multi.data_sum = multi.sun1 * 0.1 + multi.sun2
	// + multi.sun3 * 10 + multi.sun4 * 100; // 400
	// break;
	// case 2:
	// multi.data_sum = multi.sun1 * 0.01 + multi.sun2
	// * 0.1 + multi.sun3 + multi.sun4 * 10; // 40
	// break;
	// case 1:
	// multi.data_sum = multi.sun1 * 0.001 + multi.sun2
	// * 0.01 + multi.sun3 * 0.1 + multi.sun4; // 4
	// break;
	// case 0:
	// multi.data_sum = multi.sun1 + multi.sun2 * 10
	// + multi.sun3 * 100 + multi.sun4 * 1000; // 400
	// break;
	// }
	//
	// } else {
	// multi.data_sum = 8888;
	// }
	// } else
	// // MultiMeter.func_type==6 //ACA
	// {
	// if (multi.sun1_en != 0 && multi.sun2_en != 0
	// && multi.sun3_en != 0 && multi.sun4_en != 0) {
	// switch (multi.dot) {
	// case 3:
	// multi.data_sum = multi.sun1 * 0.1 + multi.sun2
	// + multi.sun3 * 10 + multi.sun4 * 100; // 400
	//
	// break;
	// case 2:
	// multi.data_sum = multi.sun1 * 0.01 + multi.sun2
	// * 0.1 + multi.sun3 + multi.sun4 * 10; // 40
	// break;
	// case 1:
	// multi.data_sum = multi.sun1 * 0.001 + multi.sun2
	// * 0.01 + multi.sun3 * 0.1 + multi.sun4; // 4
	// break;
	// case 0:
	// multi.data_sum = multi.sun1 + multi.sun2 * 10
	// + multi.sun3 * 100 + multi.sun4 * 1000; // 400
	// break;
	// }
	// } else {
	// multi.data_sum = 8888;
	// }
	// }
	//
	// if ((buff[2 - x] & 0x08) != 0) {
	// multi.data_sum = -multi.data_sum;
	// multi.polarity = 1;
	// // SignString = "-";
	// } else {
	// multi.polarity = 0;
	// // SignString = "";
	// }
	//
	// break;
	//
	// case 7:// c
	// case 8:
	// case 9:
	// if (multi.sun1_en != 0 && multi.sun2_en != 0
	// && multi.sun3_en != 0 && multi.sun4_en != 0) {
	// switch (multi.dot) {
	// case 3:
	// multi.data_sum = multi.sun1 * 0.1 + multi.sun2
	// + multi.sun3 * 10 + multi.sun4 * 100; // 512
	// break;
	// case 2:
	// multi.data_sum = multi.sun1 * 0.01 + multi.sun2 * 0.1
	// + multi.sun3 + multi.sun4 * 10; // 51.2
	// break;
	// case 1:
	// multi.data_sum = multi.sun1 * 0.001 + multi.sun2 * 0.01
	// + multi.sun3 * 0.1 + multi.sun4; // 5.12
	// break;
	// case 0:
	// multi.data_sum = multi.sun1 + multi.sun2 * 10
	// + multi.sun3 * 100 + multi.sun4 * 1000; // 5120
	// break;
	// }
	// } else {
	// multi.data_sum = 8888;
	// }
	//
	// break;
	//
	// case 10:
	// // v
	// case 11:
	// case 12:
	// if ((multi.func_type == 2) | (multi.func_type == 3)) {
	// if (multi.sun1_en != 0 && multi.sun2_en != 0
	// && multi.sun3_en != 0 && multi.sun4_en != 0) {
	// switch (multi.dot) {
	// case 3:
	// multi.data_sum = multi.sun1 * 0.1 + multi.sun2
	// + multi.sun3 * 10 + multi.sun4 * 100; // 400
	// break;
	// case 2:
	// multi.data_sum = multi.sun1 * 0.01 + multi.sun2
	// * 0.1 + multi.sun3 + multi.sun4 * 10; // 40
	// break;
	// case 1:
	// multi.data_sum = multi.sun1 * 0.001 + multi.sun2
	// * 0.01 + multi.sun3 * 0.1 + multi.sun4; // 4
	// break;
	// case 0:
	// multi.data_sum = multi.sun1 + multi.sun2 * 10
	// + multi.sun3 * 100 + multi.sun4 * 1000; // 400
	// break;
	// }
	// } else {
	// multi.data_sum = 8888;
	// }
	// } else if (multi.func_type == 1) {
	// if (multi.sun1_en != 0 && multi.sun2_en != 0
	// && multi.sun3_en != 0 && multi.sun4_en != 0) {
	// switch (multi.dot) {
	// case 3:
	// multi.data_sum = multi.sun1 * 0.1 + multi.sun2
	// + multi.sun3 * 10 + multi.sun4 * 100; // 400
	// break;
	// case 2:
	// multi.data_sum = multi.sun1 * 0.01 + multi.sun2
	// * 0.1 + multi.sun3 + multi.sun4 * 10; // 40
	// break;
	// case 1:
	// multi.data_sum = multi.sun1 * 0.001 + multi.sun2
	// * 0.01 + multi.sun3 * 0.1 + multi.sun4; // 4
	// break;
	// case 0:
	// multi.data_sum = multi.sun1 + multi.sun2 * 10
	// + multi.sun3 * 100 + multi.sun4 * 1000; // 400
	// break;
	// }
	// } else {
	// multi.data_sum = 8888;
	// }
	// }
	// if ((buff[2 - x] & 0x08) != 0) {
	// multi.data_sum = -multi.data_sum;
	// multi.polarity = 1;
	// } else {
	// multi.polarity = 0;
	// }
	//
	// break;
	//
	// }
	//
	// /*
	// * if ((buff[1 - x ] & 0x02) != 0) { MultiMeter.auto_on = true;//
	// * SW_ON; // UARTprintf( "ononon%s(%d)-%s: \n", __FILE__, __LINE__
	// * // ,__func__); } else { MultiMeter.auto_on = false;// SW_OFF; //
	// * UARTprintf( //
	// * "offoffoffoffoffoffoffoffoffoffoffoff%s(%d)-%s: \n", // __FILE__,
	// * __LINE__ ,__func__); } // UARTprintf(
	// * "%s(%d)-%s:type=%d,data=%f \n", __FILE__, __LINE__ //
	// * ,__func__,MultiMeter.func_type,MultiMeter.data_sum); if ((buff[12
	// * - x ] & 0x02) != 0) { MultiMeter.dltr_on = true;// SW_ON; } else
	// * { MultiMeter.dltr_on = false;// SW_OFF;
	// * MultiMeter.relative_data_sum = MultiMeter.data_sum;
	// * MultiMeter.relative_dot = MultiMeter.dot;
	// * MultiMeter.relative_unit = MultiMeter.unit; }
	// */
	//
	// if ((buff[1 - x] & 0x02) != 0 && (buff[12 - x] & 0x01) != 0) {
	// ModeString = "AUTO,H";
	// } else if ((buff[1 - x] & 0x02) != 0) {
	// ModeString = "AUTO";
	// } else if ((buff[12 - x] & 0x02) != 0) {
	// ModeString = "REL";
	// } else if ((buff[12 - x] & 0x01) != 0) {
	// ModeString = "HOLD";
	// } else if ((buff[1 - x] & 0x02) == 0) {
	// ModeString = "MANUAL";
	// }
	// negative = multi.polarity == 0;
	// DATA = multi.data_sum;
	//
	// // MultiMeter.relative_dot = MultiMeter.dot;
	// // MultiMeter.relative_unit = MultiMeter.unit;
	//
	// i += ONE_DATA_LENGTH;
	// // //////////////拼装数据体
	// MultimeterReceivedData receivedData = new MultimeterReceivedData();
	// ByteBuffer source = ByteBuffer.allocate(ONE_DATA_LENGTH);
	// // TODO 这里offset 不该用0
	// source.put(buff, 0, ONE_DATA_LENGTH);// i - ONE_DATA_LENGTH,
	// receivedData.SourceData = source.array();// TODO 测试
	// receivedData.SourceDataLength = ONE_DATA_LENGTH;
	// receivedData.Index = mDataList.size();
	// receivedData.Mode = ModeString;
	// receivedData.Func = FuncString;
	// receivedData.ValueString = String.valueOf(DATA);
	// receivedData.Unit = UnitString;
	// receivedData.Value = DATA;
	//
	// mDataList.add(receivedData);
	// // send
	// sendDataBrocast(client, receivedData);
	//
	// leftlength -= ONE_DATA_LENGTH;
	//
	// }
	//
	// if (result != ERROR_NONE) {
	// MSG_ERROR("handleReceivedData, Parse received data fail, result = "
	// + result);
	// return;
	// }
	//
	// if (leftlength > 0) {
	// // MSG_ERROR("handleReceivedData, " + leftlength + " bytes left");
	//
	// ByteBuffer temp = ByteBuffer.allocate(leftlength);
	//
	// temp.put(buff, i, leftlength);
	//
	// mDataLeft = temp.array();
	// mDataLeftLength = leftlength;
	// } else {
	// mDataLeft = null;
	// mDataLeftLength = 0;
	// }
	//
	// return;
	// }

	/** B33协议变量 */
	// private final int multiFunSL_diode = 3;// D
	// private final int multiFunSL_acv = 1; // acV
	// private final int multiFunSL_dcv = 2; // dcV
	// private final int multiFunSL_dca = 7; // dcA
	// private final int multiFunSL_aca = 6; // acA
	// private final int multiFunSL_rs = 8; // Rs 兆欧
	// private final int multiFunSL_R = 5; // R 欧
	// private final int multiFunSL_c = 4; // C F
	// private final int multiFunSL_reserved = 0;
	//
	// private final int multiUnit_uV = 10;
	// private final int multiUnit_mV = 11;
	// private final int multiUnit_V = 12;
	// private final int multiUnit_uF = 9;
	// private final int multiUnit_nF = 8;
	// private final int multiUnit_pF = 7;
	// private final int multiUnit_kohm = 2;
	// private final int multiUnit_Mohm = 3;
	// private final int multiUnit_ohm = 1;
	// private final int multiUnit_uA = 4;
	// private final int multiUnit_mA = 5;
	// private final int multiUnit_A = 6;
	// private final int multiUnit_RESERVED = 0;

	/** 以下是明文通用协议解析，各机型通用 */
	private boolean onCommonPrint = false;

	public void handleReceivedData_common(MultimeterClient client, byte[] data, int datalength, boolean is55) {
		if (client == null || data == null || datalength <= 0) {
			MSG_ERROR("handleReceivedData, Invalid argument");
			return;
		}

		// dumpData(data, datalength);

		ByteBuffer buffer = ByteBuffer.allocate(mDataLeftLength + datalength);

		if (mDataLeftLength > 0 && mDataLeft != null) {
			buffer.put(mDataLeft);
		}
		buffer.put(data, 0, datalength);

		byte[] tmp = buffer.array();
		int leftlength = mDataLeftLength + datalength;

		int result = ERROR_NONE;

		int i = 0;

		while (leftlength >= COMMON_ONE_DATA_LENGTH) {

			StringBuilder ModeBuilder = new StringBuilder();
			String ModeString, FuncString, DataString, unitString, rate, UnitType = "", point;
			boolean negative = false;
			double DATA;

			// 判断数据正负
			// 得到4个数据位
			/** space byte 标记验证,否则break; */
			// point = tmp[i]; 得到小数点位置byte
			// 解析并应用小数点位置到dataString
			/** point byte 标记验证,否则break; */
			// 应用正负到到dataString
			// sb1,sb2,sb3,sb4,bar的解析
			/** EOF byte 标记验证,否则break; */
			/** ENTER byte 标记验证,否则break; */
			// ModeString 解析应用 AUTO,HOLD,REL,MAX,MIN,
			// FuncString 解析应用,DC,AMP,AC
			// Unit1String 解析应用,NANO,MICRO
			// Unit2String 解析应用,VOLT,AMP,HZ
			/** 机器0L在APP上显示为奇怪150.1505的数值，对其做限制处理,含欧姆档,蜂鸣档 */

			/** KNOW 档位 */
			// 单位0x03C0 >>6, 倍率0x38 >>3, 小数点位置0x7
			byte low = tmp[i++], high = tmp[i++];
			short gear = twoBytesToShort(high, low);

			// 倍率
			switch ((gear & 0x0038) >> 3) {
			case 0:// p=0x0
				rate = RateUnit.p.toString();// "p";
				break;
			case 1:// n=0x1、
				rate = RateUnit.n.toString();// "n";
				break;
			case 2:// u=0x2、
				rate = RateUnit.u.toString();// "u";
				break;
			case 3:// m=0x3、
				rate = RateUnit.m.toString();// "m";
				break;
			case 4:// -=0x4、
				rate = RateUnit.None.toString(); // "";
				break;
			case 5:// K=0x5、
				rate = RateUnit.K.toString();// "K";
				break;
			case 6:// M=0x6、
				rate = RateUnit.M.toString();// "M";
				break;
			case 7:// G=0x7、
				rate = RateUnit.G.toString();// "G";
				break;
			default:
				// ERROR
				rate = "?";
				break;
			}

			// 单位
			switch ((gear & 0x03C0) >> 6) {
			case 0:// DCV=0x0、
				FuncString = FuncUnit.DC.toString();
				UnitType = StringRes.getString(R.unit_volt);
				unitString = rate + UnitType;// "V"
				break;
			case 1:// ACV=0x1、
				FuncString = FuncUnit.AC.toString();
				UnitType = StringRes.getString(R.unit_volt);
				unitString = rate + UnitType;// "V"
				break;
			case 2:// DCA=0x2、
				FuncString = FuncUnit.DC.toString();
				UnitType = StringRes.getString(R.unit_ampere);
				unitString = rate + UnitType;// "A"
				break;
			case 3:// ACA=0x3、
				FuncString = FuncUnit.AC.toString();
				UnitType = StringRes.getString(R.unit_ampere);
				unitString = rate + UnitType;// "A"
				break;
			case 4:// Ω=0x4、
				FuncString = FuncUnit.OHM.toString();
				UnitType = StringRes.getString(R.unit_ohm);
				unitString = rate + UnitType;// "Ω"
				break;
			case 5:// F=0x5、
				FuncString = FuncUnit.F.toString();
				UnitType = StringRes.getString(R.unit_farad);
				unitString = rate + UnitType;// "F"
				break;
			case 6:// Hz=0x6、
				FuncString = FuncUnit.Hz.toString();
				UnitType = StringRes.getString(R.unit_Hz);
				unitString = rate + UnitType;// "Hz"
				break;
			case 7:// %=0x7、
				FuncString = FuncUnit.Percent.toString();
				UnitType = unitString = StringRes.getString(R.unit_percent);// "%"
				break;
			case 8:// ℃=0x8、
				FuncString = FuncUnit.Centigrade.toString();
				UnitType = StringRes.getString(R.unit_centigrade);
				unitString = rate + UnitType;// "℃"
				break;
			case 9:// ℉=0x9、
				FuncString = FuncUnit.Fahrenheit.toString();
				UnitType = StringRes.getString(R.unit_fahrenheit);
				unitString = rate + UnitType;// "℉"
				break;
			case 10:// Diode=0xA、
				FuncString = FuncUnit.Diode.toString();
				UnitType = StringRes.getString(R.unit_volt);
				unitString = rate + UnitType;// "V"
				break;
			case 11:// Continuity=0xB、
				FuncString = FuncUnit.Continuity.toString();
				UnitType = StringRes.getString(R.unit_ohm);
				unitString = rate + UnitType;// "Ω"
				break;
			case 12:// hFE=0xC、
				UnitType = FuncString = unitString = FuncUnit.HFEC.toString();
				break;
			case 13:// ADP=0xD、
				BleClient bc = (BleClient) client;
				if (bc.getBleSeries().isOWSeries()) {
					FuncString = unitString = FuncUnit.NCV.toString();
					System.out.println("isOW18 NCV");
				} else {
					FuncString = unitString = FuncUnit.ADP.toString();
					System.out.println("else ADP");
				}
				break;
			default:// ERROR
				UnitType = FuncString = unitString = "Null";
				break;
			}

			/** KNOW 状态 */
			low = tmp[i++];
			high = tmp[i++];
			short func = twoBytesToShort(high, low);
			char[] binary = Integer.toBinaryString(func).toCharArray();

			Status[] allStatus = Status.values();
			// ArrayList<String> onStatus = new ArrayList<String>();
			int m = 0, n = 0, al = allStatus.length, bl = binary.length;

			for (; m < al; m++) {
				if ((m >= al - bl)) {
					if (binary[n] == '1') {
						ModeBuilder.append(allStatus[m].name());
						ModeBuilder.append(",");
						// onStatus.add(allStatus[m].name());
						if (onCommonPrint)
							System.out.println("Status: " + allStatus[m].name() + "," + binary[n] + "(" + m + "),");
					}
					n++;
				}
			}
			ModeString = ModeBuilder.toString();
			/** KNOW 数值 */
			low = tmp[i++];
			high = tmp[i++];
			
//			System.out.println("H:"+Integer.toString((int)high, 2));
//			System.out.println("L:"+Integer.toString((int)low, 2));

			// negative = (high >> 7) != 0;// 正负号位从bit15移动到bit0,(1负,0正)
			// DATA = oneData & 0x7FFF;
			// int ORG_DATA = oneData & 0x7FFF;
			int ORG_DATA;
			if (is55) {
				int oneData = twoBytesToInt(high, low);
				negative = ((gear >> 10) & 1) != 0;// 正负号位从bit15移动到bit0,(1负,0正)
				ORG_DATA = oneData;
			} else {
				short oneData = twoBytesToShort(high, low);
				negative = (high >> 7) != 0;// 正负号位从bit15移动到bit0,(1负,0正)
				ORG_DATA = oneData & 0x7FFF;
			}
			DATA = ORG_DATA;

			// 小数点
			int decimal = gear & 0x0007;
			switch (decimal) {
			case 0:
				point = "00000";
				break;
			case 1:
				DATA /= 10;
				point = "0000.0";
				break;
			case 2:
				DATA /= 100;
				point = "000.00";
				break;
			case 3:
				DATA /= 1000;
				point = "00.000";
				break;
			case 4:
				DATA /= 10000;
				point = "0.0000";
				break;
			case 6:
				point = "UL";
				break;
			case 7:
				point = "OL";
				break;
			default:
				point = "err point";
				break;
			}

			boolean isU_O = point.equals("UL") || point.equals("OL");
			DataString = isU_O ? point : (String.valueOf(DATA));

			if (FuncString.equalsIgnoreCase(FuncUnit.NCV.toString())) {
				switch ((int) DATA) {
				case 0:
					DataString = "EF";
					break;
				case 1:
					DataString = "-";
					break;
				case 2:
					DataString = "- -";
					break;
				case 3:
					DataString = "- - -";
					break;
				case 4:
					DataString = "- - - -";
					break;
				}
			} else {
				BleClient bc = (BleClient) client;
				if (bc.getBleSeries().isB41()||bc.getBleSeries().isOW55()) {
					switch (decimal) {
					// case 0:
					case 1:
					case 2:
					case 3:
					case 4:
						String v_t = String.format("%05d", ORG_DATA);
						int dec = 5 - decimal;
						DataString = v_t.substring(0, dec) + "." + v_t.substring(dec);
					default:
						break;
					}
				} else {
					switch (decimal) {
					// case 0:
					case 1:
					case 2:
					case 3:
					case 4:
						String v_t = String.format("%04d", ORG_DATA);
						int dec = 4 - decimal;
						DataString = v_t.substring(0, dec) + "." + v_t.substring(dec);
					default:
						break;
					}
				}

			}

			if (negative) {
				DATA = -DATA;
				DataString = "-" + DataString;
			}

			
			// //////////////拼装数据体
			// timer.stop();
			// long tmpt = timer.measure();
			// if (tmpt >= IntervalTime) {
			// timer.start();

			MultimeterReceivedData receivedData = new MultimeterReceivedData();
			ByteBuffer source = ByteBuffer.allocate(COMMON_ONE_DATA_LENGTH);
			source.put(tmp, i - COMMON_ONE_DATA_LENGTH, COMMON_ONE_DATA_LENGTH);
			receivedData.mAddress = mAddress;
			receivedData.SourceData = source.array();
			receivedData.SourceDataLength = COMMON_ONE_DATA_LENGTH;
			receivedData.Index = mDataList.size();
			receivedData.Mode = ModeString;
			receivedData.Func = FuncString;
			receivedData.ValueString = DataString;
			receivedData.UnitType = UnitType;
			receivedData.Unit = unitString;
			receivedData.Value = DATA;// unifiedUnit(DATA,receivedData.Unit);//
			receivedData.Range=decimal;

			mDataList.add(receivedData);
			// sendDataBrocast(client, receivedData);
			if (onCommonPrint) {
//				System.out.println("倍率：" + rate);
//				System.out.println("单位：" + unitString);
//				System.out.println(al + "," + bl);
//				System.out.println("正负: " + (negative ? "-" : "+"));
//				System.out.println("小数点：" + point);
//				System.out.println("后台数值: " + DATA);
//				System.out.println("显示数值: " + DataString);

//				System.err.println("#Gear: " + Integer.toBinaryString(gear & 0xffff));
//				System.err.println("#Status: " + Integer.toBinaryString(func));
//				System.err.println("#Data1: " + Integer.toBinaryString(high));
//				System.err.println("#Data2: " + Integer.toBinaryString(oneData & 0x7FFF));
			
				System.out.println("Mode：" + ModeString);
				System.out.println("#Func：" + FuncString);
				System.out.println("ValueString：" + DataString);
				System.out.println("UnitType：" + UnitType);
				System.out.println("Unit：" + unitString);
				System.out.println("Value：" + DATA);
				System.out.println("#Range：" + decimal);
			}
			Platform.getBle().broadcast.sendRealDataBroadcast(0, receivedData);
			// }

			leftlength -= COMMON_ONE_DATA_LENGTH;
		}

		if (result != ERROR_NONE) {
			MSG_ERROR("handleReceivedData, Parse received data fail, result = " + result);
			return;
		}

		if (leftlength > 0) {
			// MSG_ERROR("handleReceivedData, " + leftlength + " bytes left");
			ByteBuffer temp = ByteBuffer.allocate(leftlength);
			temp.put(tmp, i, leftlength);

			mDataLeft = temp.array();
			mDataLeftLength = leftlength;
		} else {
			mDataLeft = null;
			mDataLeftLength = 0;
		}

		return;
	}

	private short twoBytesToShort(byte high, byte low) {
		return (short) (((high & 0x00ff) << 8) | (low & 0x00ff));
	}
	
	private int twoBytesToInt(byte high, byte low) {
		return (int) (((high & 0x00ff) << 8) | (low & 0x00ff));
	}

	public enum Status {
		VBAR(13), LPF1(12), LPF0(11), UL(10), PMAX(9), PMIN(8), RMR(7), OL(6), MAX(5), MIN(4), Bat(3), AUTO(2), REL(
				1), HOLD(0),;

		private boolean on = false;
		private int order = -1;

		private Status(int code) {
			this.order = code;
		}

	}

	//
	// private File savedFile;
	// private String savedFileName = "";
	// private byte[] mDataLeft_flash;
	// private int mDataLeftLength_flash = 0;
	// private static final int FLASH_ONE_DATA_LENGTH = 2;
	//
	// private byte[] LenArr = new byte[4];
	// private int LenPt = 0, markCount = 0;;
	// private boolean status = false, onGetting = false, onMark = false;
	// private short gear = (short) 0xF000;// 0xF020
	// private String ModeString = "FLM", FuncString = "FLF", unitString =
	// "FLU";
	//
	// private int readbytescount = 0;

	protected void handleReceivedData_flash55(MultimeterClient client, byte[] data, int datalength) {

		offlineDataModel.handleData(client, data, datalength, true);
		// offlineTest.collectFlashData(client, data, datalength);
	}

	protected void handleReceivedData_flash2(MultimeterClient client, byte[] data, int datalength) {

		offlineDataModel.handleData(client, data, datalength, false);
		// offlineTest.collectFlashData(client, data, datalength);
	}

	public void preSetFileName(String filename) {
		offlineDataModel.preSetFileName(filename);
	}

	// protected void handleReceivedData_flash(MultimeterClient client,
	// byte[] data, int datalength) {
	// if (client == null || data == null || datalength <= 0) {
	// MSG_ERROR("handleReceivedData, Invalid argument");
	// return;
	// }
	// readbytescount += datalength;
	// // dumpData(data, datalength);
	//
	// ByteBuffer buffer = ByteBuffer.allocate(mDataLeftLength_flash
	// + datalength);
	//
	// if (mDataLeftLength_flash > 0 && mDataLeft_flash != null) {
	// buffer.put(mDataLeft_flash);
	// }
	// buffer.put(data, 0, datalength);
	//
	// byte[] tmp = buffer.array();
	// int leftlength = mDataLeftLength_flash + datalength;
	//
	// int result = ERROR_NONE;
	//
	// int i = 0;
	//
	// while (leftlength >= FLASH_ONE_DATA_LENGTH) {
	// byte low = tmp[i++];
	// byte high = tmp[i++];
	// leftlength -= FLASH_ONE_DATA_LENGTH;
	// status = onGetting;
	// onMark = (low & 0xff) == 0xff && (high & 0xff) == 0xff;
	// // if (pastMark && !nowMark) {
	// // onGetting = true;
	// // LenPt = 0;
	// // MSG_INFO("onGetting true:" + onGetting);
	// // } else if (!pastMark && nowMark) {
	// // onGetting = false;
	// // isOnFlashTransmit = false;
	// // MSG_INFO("onGetting false:" + onGetting);
	// // }
	// if (onMark && !onGetting) {
	// MSG_INFO("nowMark:" + onMark + "，c:" + markCount);
	// // pastMark:" + pastMark + "，
	// markCount++;
	// readbytescount = 0;
	// } else if (onMark && onGetting) {
	// MSG_INFO("nowMark:" + onMark + "，c:" + markCount);
	// // pastMark:" + pastMark + "，
	// markCount--;
	// }
	//
	// if (markCount >= 10) {
	// onGetting = true;
	// } else if (markCount <= 0) {
	// onGetting = false;
	// }
	//
	// if (status && !onGetting) {
	// setTransmitState(STATE_TRANSMIT_REAL_TIME);// STATE_TRANSMIT_FLASH
	// LenPt = 0;
	// MSG_INFO("Flash data transmit over ,send broadcast to saveData");
	//
	// Intent intent = new Intent(
	// SPool.ACTION_READ_PROGRESS_END_TOSAVE);
	// mContext.sendBroadcast(intent);
	// saveFlashReceivedData();
	//
	// }
	//
	// String DataString = "Null";
	// double DATA = 0;
	//
	// /* 解析数据体 */
	// if (onGetting && !onMark) {
	// MSG_INFO("readbytes:" + readbytescount + ",high:"
	// + String.format("%02X", high) + ", low:"
	// + String.format("%02X", low));
	//
	// if (LenPt < LenArr.length) {
	//
	// LenArr[LenPt++] = low;
	// LenArr[LenPt++] = high;
	// MSG_INFO("LenPt:" + LenPt);
	// } else {
	// if (LenPt == LenArr.length) {
	// int len = LenArr[3] << 24 | LenArr[2] << 16
	// | LenArr[1] << 8 | LenArr[0];
	// LenPt++;
	// MSG_INFO("$$$$$$$$$$$$$$##### LenPt:" + len);
	// }
	//
	// if ((high & 0xfc) == 0xf0) {
	// MSG_INFO("$$$$$$$$$$$$$$##### In Gear:");
	// String rate;
	// // 单位0x03C0 >>6, 倍率0x38 >>3, 小数点位置0x7
	// gear = twoBytesToShort(high, low);
	//
	// // 倍率
	// switch ((gear & 0x0038) >> 3) {
	// case 0:// p=0x0
	// rate = RateUnit.p.toString();// "p";
	// break;
	// case 1:// n=0x1、
	// rate = RateUnit.n.toString();// "n";
	// break;
	// case 2:// u=0x2、
	// rate = RateUnit.u.toString();// "u";
	// break;
	// case 3:// m=0x3、
	// rate = RateUnit.m.toString();// "m";
	// break;
	// case 4:// -=0x4、
	// rate = RateUnit.None.toString(); // "";
	// break;
	// case 5:// K=0x5、
	// rate = RateUnit.K.toString();// "K";
	// break;
	// case 6:// M=0x6、
	// rate = RateUnit.M.toString();// "M";
	// break;
	// case 7:// G=0x7、
	// rate = RateUnit.G.toString();// "G";
	// break;
	// default:
	// // ERROR
	// rate = "?";
	// break;
	// }
	//
	// // 单位
	// switch ((gear & 0x03C0) >> 6) {
	// case 0:// DCV=0x0、
	// FuncString = FuncUnit.DC.toString();// "DC";
	// unitString = rate
	// + StringRes.getString(R.unit_volt);
	// break;
	// case 1:// ACV=0x1、
	// FuncString = FuncUnit.AC.toString();// "AC";
	// unitString = rate
	// + StringRes.getString(R.unit_volt);
	// break;
	// case 2:// DCA=0x2、
	// FuncString = FuncUnit.DC.toString();// "DC";
	// unitString = rate
	// + StringRes.getString(R.unit_ampere);
	// break;
	// case 3:// ACA=0x3、
	// FuncString = FuncUnit.AC.toString();// "AC";
	// unitString = rate
	// + StringRes.getString(R.unit_ampere);
	// break;
	// case 4:// Ω=0x4、
	// FuncString = StringRes.getString(R.unit_ohm);// "Ω";
	// unitString = rate + FuncString;
	// break;
	// case 5:// F=0x5、
	// FuncString = FuncUnit.F.toString();// "F";
	// unitString = rate + FuncString;
	// break;
	// case 6:// Hz=0x6、
	// FuncString = FuncUnit.Hz.toString();// "Hz";
	// unitString = rate + FuncString;
	// break;
	// case 7:// %=0x7、
	// FuncString = unitString = StringRes
	// .getString(R.unit_percent);// "%";
	// break;
	// case 8:// ℃=0x8、
	// FuncString = unitString = StringRes
	// .getString(R.unit_centigrade);// "℃";
	// break;
	// case 9:// ℉=0x9、
	// FuncString = StringRes
	// .getString(R.unit_fahrenheit);// "℉";
	// unitString = rate + FuncString;
	// break;
	// case 10:// Diode=0xA、
	// FuncString = FuncUnit.Diode.toString();// "Diode";
	// unitString = rate + FuncString;
	// break;
	// case 11:// Continuity=0xB、
	// FuncString = unitString = FuncUnit.Continuity
	// .toString();// "Continuity";
	// break;
	// case 12:// hFE=0xC、
	// FuncString = unitString = FuncUnit.HFEC.toString();// "hFE";
	// break;
	// case 13:// ADP=0xD、
	// FuncString = unitString = FuncUnit.ADP.toString();// "ADP";
	// break;
	// default:// ERROR
	// FuncString = unitString = "?";
	// break;
	// }
	//
	// } else {
	//
	// String point = "?";
	// short oneData = twoBytesToShort(high, low);
	// boolean negative = (high >> 7) != 0;// 正负号位从bit15移动到bit0,(1负,0正)
	// DATA = oneData & 0x7FFF;
	// // 小数点
	// switch (gear & 0x0007) {
	// case 0:
	// point = "00000";
	// break;
	// case 1:
	// DATA /= 10;
	// point = "0000.0";
	// break;
	// case 2:
	// DATA /= 100;
	// point = "000.00";
	// break;
	// case 3:
	// DATA /= 1000;
	// point = "00.000";
	// break;
	// case 4:
	// DATA /= 10000;
	// point = "0.0000";
	// break;
	// case 6:
	// point = "UL";
	// break;
	// case 7:
	// point = "OL";
	// break;
	// default:
	// point = "?";
	// break;
	// }
	//
	// boolean isU_O = point.equals("UL")
	// || point.equals("OL");
	//
	// if (negative) {
	// DATA = -DATA;
	// }
	// DataString = isU_O ? point : (String.valueOf(DATA));
	//
	// MultimeterReceivedData receivedData = new MultimeterReceivedData();
	// ByteBuffer source = ByteBuffer
	// .allocate(FLASH_ONE_DATA_LENGTH);
	// source.put(tmp, i - FLASH_ONE_DATA_LENGTH,
	// FLASH_ONE_DATA_LENGTH);
	// receivedData.SourceData = source.array();
	// receivedData.SourceDataLength = FLASH_ONE_DATA_LENGTH;
	// receivedData.Index = getFlashDataList().size();
	// receivedData.Mode = ModeString;
	// receivedData.Func = FuncString;
	// receivedData.Unit = unitString;
	// receivedData.ValueString = DataString;
	// receivedData.Value = DATA;
	//
	// MSG_INFO("In number,id:" + receivedData.Index
	// + ",Mode:" + ModeString + ",Func:" + FuncString
	// + ",Unit:" + unitString + ",Vs:" + DataString
	// + ",v:" + DATA);
	//
	// getFlashDataList().add(receivedData);
	// sendDataBrocast(client, receivedData);
	// }
	// }
	// Intent intent = new Intent(SPool.ACTION_READ_PROGRESS_VALUE);
	// intent.putExtra(SPool.EXTRA_READ_PROGRESS_VALUE,
	// FLASH_ONE_DATA_LENGTH);
	// mContext.sendBroadcast(intent);
	// }
	//
	// // leftlength -= FLASH_ONE_DATA_LENGTH;
	// }
	//
	// if (result != ERROR_NONE) {
	// MSG_ERROR("handleReceivedData, Parse received data fail, result = "
	// + result);
	// return;
	// }
	//
	// if (leftlength > 0) {
	// // MSG_ERROR("handleReceivedData, " + leftlength + " bytes left");
	// ByteBuffer temp = ByteBuffer.allocate(leftlength);
	// temp.put(tmp, i, leftlength);
	//
	// mDataLeft_flash = temp.array();
	// mDataLeftLength_flash = leftlength;
	// } else {
	// mDataLeft_flash = null;
	// mDataLeftLength_flash = 0;
	// }
	//
	// return;
	// }

	// public File saveFlashReceivedData() {
	// return offlineDataModel.saveFlashDatasAfterParsed(this);
	// }
	//
	// public List<MultimeterReceivedData> getFlashDataList() {
	// return offlineDataModel.getFlashDataList();
	// }
	//
	// public void abortReadingFlashData() {
	// offlineDataModel.clearDataList();
	// disconnect();
	// }
	//
	// public void preSetFileName(String filename) {
	// offlineDataModel.preSetFileName(filename);
	// }
	//
	// public File getFlashDataFileAsSaved() {
	// return offlineDataModel.getFlashDataFile();
	// }

	// public static final int MESSAGE_STATE_CHANGE = 1;
	// public static final int MESSAGE_READ = 2;
	// public static final int MESSAGE_WRITE = 3;
	// public static final int REASON_RfcommSocket = 11;
	// public static final int REASON_InsecureRfcommSocket = 12;
	// public static final int REASON_CREATSOCKET_FAIL = 21;
	// public static final int REASON_SOCKET_CONNECT_EXCEPTION = 22;
}
