package main;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;

import javax.swing.SwingUtilities;

import kernal.BleAgent;
import control.Global;
import control.MainControl;
import frame.i18n.StringRes;

public class Platform {

	private static Thread ui;
	private static BleAgent ag;
	private static MainControl mc;

	public static void launch() {
		ag = new BleAgent();
		mc = new MainControl();

		try {
			SwingUtilities.invokeAndWait(new Runnable() {

				@Override
				public void run() {
					Global.getInstance().setDefaultLocale();

					mc.launchMainFrame();
					ui = Thread.currentThread();
				}
			});
		} catch (InterruptedException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}

		try {
			ui.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	public static BleAgent getBle() {
		return ag;
	}

	public static MainControl getMain() {
		return mc;
	}

}
