package kernal;

import model.BleSeriesInfo;
import model.SeriesBT;
import model.SeriesOW;

public class Command {

	// OpCode
	public static final int GATT_WriteLongCharValue = 0xFD96;
	public static final int GATT_ReadCharValue = 0xFD8A;
	public static final int GATT_WriteCharValue = 0xFD92;

	public static final byte F1FF = 0X25;
	public static final byte F2FF = 0X28;
	public static final byte F3FF = 0X2B;
	public static final byte F4FF = 0X2E;

	public static final byte[] F1_RW_UUID = { (byte) 0xF1, (byte) 0xFF };
	public static final byte[] F2_R_UUID = { (byte) 0xF2, (byte) 0xFF };
	public static final byte[] F3_W_UUID = { (byte) 0xF3, (byte) 0xFF };

	public static boolean sDebug = true;

	public static byte[] GATT_WriteCharValue_handle(byte[] connHandle,
			byte[] rwHandle, byte[] value) {
		// -Type : 0x01 (Command)
		// -OpCode : 0xFD92 (GATT_WriteCharValue)
		// -Data Length : 0x06 (6) byte(s)
		// ConnHandle : 0x0000 (0)
		// Handle : 0x002B (43)
		// Value : 01:01
		byte commandType = 0x01;
		byte opCodeLow = (byte) 0x92;
		byte opCodeHigh = (byte) 0xFD;
		byte dataLength = (byte) (4 + value.length);
		byte connHandleLow = connHandle[0];
		byte connHandleHigh = connHandle[1];
		byte handleLow = rwHandle[0];
		byte handleHigh = rwHandle[1];

		byte[] temp = { commandType, opCodeLow, opCodeHigh, dataLength,
				connHandleLow, connHandleHigh, handleLow, handleHigh };
		byte[] cmds = new byte[temp.length + value.length];
		System.arraycopy(temp, 0, cmds, 0, temp.length);
		System.arraycopy(value, 0, cmds, temp.length, value.length);

		return cmds;
	}

	public static byte[] GATT_WriteLongCharValue_handle(byte[] connHandle,
			byte[] rwHandle, byte[] value) {
		// -Type : 0x01 (Command)
		// -OpCode : 0xFD96 (GATT_WriteLongCharValue)
		// -Data Length : 0x16 (22) byte(s)
		// ConnHandle : 0x0000 (0)
		// Handle : 0x0025 (37)
		// Offset : 0x0000 (0)
		// Value : D2:70:40:14:0B:07:00:00:00:00:00:00:00:00:00:00
		byte commandType = 0x01;
		byte opCodeLow = (byte) 0x96;
		byte opCodeHigh = (byte) 0xFD;
		byte dataLength = (byte) (6 + value.length);

		byte connHandleLow = connHandle[0];
		byte connHandleHigh = connHandle[1];
		byte handleLow = rwHandle[0];
		byte handleHigh = rwHandle[1];
		byte[] temp = { commandType, opCodeLow, opCodeHigh, dataLength,
				connHandleLow, connHandleHigh, handleLow, handleHigh, 0, 0 };

		byte[] cmds = new byte[temp.length + value.length];
		System.arraycopy(temp, 0, cmds, 0, temp.length);
		System.arraycopy(value, 0, cmds, temp.length, value.length);

		return cmds;

	}

	public static byte[] GATT_ReadCharValue_handle(byte[] connHandle,
			byte handle) {
		// -Type : 0x01 (Command)
		// -OpCode : 0xFD8A (GATT_ReadCharValue)
		// -Data Length : 0x04 (4) byte(s)
		// ConnHandle : 0x0000 (0)
		// Handle : 0x0025 (37)
		byte commandType = 0x01;
		byte opCodeLow = (byte) 0x8A;
		byte opCodeHigh = (byte) 0xFD;
		byte dataLength = (byte) 0x04;
		byte connHandleLow = connHandle[0];
		byte connHandleHigh = connHandle[1];
		byte handleLow = handle;
		byte handleHigh = 0;

		byte[] cmds = { commandType, opCodeLow, opCodeHigh, dataLength,
				connHandleLow, connHandleHigh, handleLow, handleHigh };
		return cmds;
	}

	public static byte[] GATT_ReadCharValue_byUUID(byte[] connHandle,
			byte[] uuid) {
		// -Type : 0x01 (Command)
		// -OpCode : 0xFDB4 (GATT_ReadUsingCharUUID)
		// -Data Length : 0x08 (8) byte(s)
		// ConnHandle : 0x0000 (0)
		// StartHandle : 0x0001 (1)
		// EndHandle : 0xFFFF (65535)
		// Type : F2:FF
		// Dump(Tx):
		// 0000:01 B4 FD 08 00 00 01 00 FF FF F2 FF ............
		byte commandType = 0x01;
		byte opCodeLow = (byte) 0xB4;
		byte opCodeHigh = (byte) 0xFD;
		byte dataLength = (byte) 0x08;
		byte connHandleLow = connHandle[0];
		byte connHandleHigh = connHandle[1];
		byte startHandleLow = 0x01;
		byte startHandleHigh = 0;
		byte endHandleLow = (byte) 0xFF;
		byte endHandleHigh = (byte) 0xFF;
		byte typeLow = uuid[0];
		byte typeHigh = uuid[1];

		byte[] cmds = { commandType, opCodeLow, opCodeHigh, dataLength,
				connHandleLow, connHandleHigh, startHandleLow, startHandleHigh,
				endHandleLow, endHandleHigh, typeLow, typeHigh };
		return cmds;
	}

	public static byte[] initcmd() {
		byte[] arr = { (byte) 0x01, (byte) 0x00, (byte) 0xFE, (byte) 0x26,
				(byte) 0x08, (byte) 0x05, (byte) 0x00, (byte) 0x00,
				(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
				(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
				(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
				(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
				(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
				(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
				(byte) 0x00, (byte) 0x00, (byte) 0x00, (byte) 0x00,
				(byte) 0x00, (byte) 0x00, (byte) 0x01, (byte) 0x00,
				(byte) 0x00, (byte) 0x00 };
		return arr;
	}

	private enum DiscoveryMode{
		Non_Connectable((byte) 0x00),General((byte) 0x01),Limited((byte) 0x02),All((byte) 0x03);
		
		public  byte value ;
	    private DiscoveryMode(   byte index ){
	        this.value = index ;
	    }
	}
	public static byte[] discoveryRequest() {
		byte[] arr = { (byte) 0x01, (byte) 0x04, (byte) 0xFE, (byte) 0x03,
				DiscoveryMode.General.value, (byte) 0x01, (byte) 0x00 };
		return arr;
	}

	public static byte[] linkRequest(byte[] slaveAddr) {
		// -Type : 0x01 (Command)
		// -OpCode : 0xFE09 (GAP_EstablishLinkRequest)
		// -Data Length : 0x09 (9) byte(s)
		// HighDutyCycle : 0x00 (0) (Disable)
		// WhiteList : 0x00 (0) (Disable)
		// AddrTypePeer : 0x00 (0) (Public)
		// PeerAddr : 98:7B:F3:22:37:2C
		byte[] arr = { (byte) 0x01, (byte) 0x09, (byte) 0xFE, (byte) 0x09,
				(byte) 0x00, (byte) 0x00, (byte) 0x00 };

		byte[] cmds = new byte[arr.length + 6];
		System.arraycopy(arr, 0, cmds, 0, arr.length);
		System.arraycopy(slaveAddr, 0, cmds, arr.length, 6);

		return cmds;
	}

	public static byte[] terminateLinkRequest(byte[] connHandle) {
		byte[] arr = { (byte) 0x01, (byte) 0x0A, (byte) 0xFE, (byte) 0x03,
				connHandle[0], connHandle[1], (byte) 0x13 };
		return arr;
	}

	public static byte[] getHandle(BleSeriesInfo series, byte charIdx) {
		if (series.isOWSeries()) {
			return SeriesOW.getHandle(charIdx);
		} else {
			return SeriesBT.getHandle(charIdx);
		}
	}

	public static void println(String s) {
		if (sDebug)
			System.out.println(s);
	}

}
