package kernal;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;

import storeroom.util.ByteUtil;

import main.Platform;
import model.BleClientGattCallback;
import model.BleSlaveManager;
import model.ConnHandleResult;
import model.DiscoverResult;
import control.BroadcastAgent;

public class BleAgent implements Runnable, SerialPortEventListener {

	public static final int STATE_DISCONNECTED = 0, STATE_CONNECTED = 1;
	public static final int STATE__SUCESS = 2, STATE__ERROR = 3;
	private String UserSelectedPort = "";
	private int baud = 115200;

	public BroadcastAgent broadcast;
	private BleSlaveManager slaveManager;
	// BleClient mClient;

	CommPortIdentifier portId;
	Enumeration portList;

	private InputStream inputStream;
	private OutputStream outputStream;
	private Thread readThread;
	private SerialPort serialPort;

	public BleAgent() {
		broadcast = new BroadcastAgent();
		slaveManager = new BleSlaveManager();
	}

	public void setUserSelectedPort(String port) {
		this.UserSelectedPort = port;
	}

	public void run() {
		portList = CommPortIdentifier.getPortIdentifiers();
		while (portList.hasMoreElements()) {
			/* 强制转换为通讯端口类型 */
			portId = (CommPortIdentifier) portList.nextElement();
			if (portId.getPortType() == CommPortIdentifier.PORT_SERIAL) {

				if (portId.getName().equals(UserSelectedPort)) {

					try {
						serialPort = (SerialPort) portId.open("MyCommCC2540",
								2000);
						String result = "OPEND PORT " + portId.getName();
						broadcast.sendBroadcast_PortFound(true, result);
						System.err.println("BleAgent." + result);
					} catch (PortInUseException e) {
						e.printStackTrace();
						// TODO 打开端口失败，提醒PortInUse
					}

					initPort();
					initBleHciRequest();

					break;
				}
			}
		}

		// TODO 若找不到串口，停止执行
		if (serialPort == null) {
			String result = "Can not open port " + UserSelectedPort;
			broadcast.sendBroadcast_PortFound(false, result);
			System.err.println(result);
			return;
		}

		// try {
		// Thread.sleep(1000);
		// } catch (InterruptedException e) {
		// }\

	}

	private void initPort() {
		try {
			inputStream = serialPort.getInputStream();
			outputStream = serialPort.getOutputStream();
		} catch (IOException e) {
			e.printStackTrace();
			// TODO 提醒端口为空
		}
		/* 设置串口监听器 */
		try {
			serialPort.addEventListener(this);
		} catch (TooManyListenersException e) {
			e.printStackTrace();
		}

		/* 设置串口通讯参数：波特率、数据位、停止位、奇偶校验 */
		try {

			serialPort.setSerialPortParams(baud, SerialPort.DATABITS_8,
					SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
		} catch (UnsupportedCommOperationException e) {
			e.printStackTrace();
		}

		/* 侦听到串口有数据,触发串口事件 */
		serialPort.notifyOnDataAvailable(true);
	}

	private boolean sendCommand(byte[] command, String event) {
		if (outputStream == null) {
			System.err.println("outputStream null");
			return false;
		}

		try {
			outputStream.write(command);
			outputStream.flush();
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		StringBuilder sb = new StringBuilder();
		for (byte b : command) {
			sb.append(String.format("%02X ", b));
		}
		broadcast.sendActionBroadcast(null,
				"Wr:" + event + "\t" + sb.toString() + "\n\n");

		Command.println("Wr:" + event + "\t" + sb.toString() + "\n");
		try {
			Thread.sleep(100);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		return true;
	}

	private void initBleHciRequest() {
		sendCommand(Command.initcmd(), "initcmd");
		// TODO 开始计时，如果超时则发送mClient的超时回调
		// if(timeout){
		// mClient.getCallback().onInitHciState(false);
		// }
	}

	// 如果handle不固定，则开启本方法搜索handle
	private void initHandleServices() {
	};

	/** 以下是公用方法 */

	public void openSeriesPort() {
		/* 点击按扭所触发的事件：打开串口,并监听串口. */
		readThread = new Thread(BleAgent.this);
		readThread.start();
	}

	public void discoveryRequest() {
		sendCommand(Command.discoveryRequest(), "discoveryRequest");
	}

	public boolean linkRequest(DiscoverResult slave,
			BleClientGattCallback bleCallback) {

		boolean success = BleSlaveManager.onCreateClient(slave.addrName,
				bleCallback);
		if (success) {
			sendCommand(Command.linkRequest(slave.addr), "linkRequest");
		} else {
			// TODO 已经建立过此连接
			System.err.println("it had this connection already");// 已经建立过此连接
		}
		return success;
	}

	@Deprecated
	public void terminateLinkRequest(BleClient client) {
		BleSlaveManager.onPopupClient(client);
		if (client != null) {
			byte[] connHandle = client.getConnHandle().getConnArr();
			if (connHandle != null) {
				sendCommand(Command.terminateLinkRequest(connHandle),
						"Terminate");
			} else {
				System.err.println("connHandle is null");// 设备连接号为空
			}

		} else {
			// TODO 没有找到
			System.err.println("can`t find the slave,cannot stop");// 没有找到这个从属设备,无法停止
		}

	}

	public void terminateLinkRequest(byte[] connHandle) {
		if (connHandle != null) {
			sendCommand(Command.terminateLinkRequest(connHandle), "Terminate");
		} else {
			System.err.println("connHandle is null");
		}
	}

	public void writeRequest(byte[] cmds) {
		sendCommand(cmds, "writeRequest");
	}

	public void readRequest(byte[] cmds) {
		sendCommand(cmds, "readRequest");
	}

	/* 串口监听器触发的事件，设置串口通讯参数，读取数据并写到文本区中 */
	public void serialEvent(SerialPortEvent event) {

		switch (event.getEventType()) {
		/* Break interrupt */
		case SerialPortEvent.BI:
			System.out.println("BI");
			break;
		/* Overrun error */
		case SerialPortEvent.OE:
			System.out.println("OE");
			break;
		/* Framing error */
		case SerialPortEvent.FE:
			System.out.println("FE");
			break;
		/* Parity error */
		case SerialPortEvent.PE:
			System.out.println("PE");
			break;
		/* Carrier detect */
		case SerialPortEvent.CD:
			System.out.println("CD");
			break;
		/* Clear to send */
		case SerialPortEvent.CTS:
			System.out.println("CTS");
			break;
		/* Data set ready */
		case SerialPortEvent.DSR:
			System.out.println("DSR");
			break;
		/* Ring indicator */
		case SerialPortEvent.RI:
			System.out.println("RI");
			break;
		/* Output buffer empty */
		case SerialPortEvent.OUTPUT_BUFFER_EMPTY:
			System.out.println("OUTPUT_BUFFER_EMPTY");
			break;
		/* Data available */
		case SerialPortEvent.DATA_AVAILABLE:
			// System.err.println("serialEvent run,"+event.getOldValue() + "|" +
			// event.getNewValue());
			dealAvailableData();
			break;
		default:
		}

	}

	private void dealAvailableData() {
		

		try {
			byte[] buf = ByteUtil.readInputStreamToBuf(inputStream);

			distinguishRespondType(buf);

			// broadcast.sendActionBroadcast(null,
			// "Rn:(" + readlen + ")\n" + sb.toString() + "\n\n");
			// Event.printlnDump(readlen, sb.toString());

		} catch (IOException e) {
		}
	}

	private void distinguishRespondType(byte[] buf) {
		String hexStr = ByteUtil.getBytesHexStr(buf);
		/* 接收的数据发送出去显示 */
		broadcast.sendActionBroadcast(null, "Rn:(" + buf.length + ")\n"
				+ hexStr + "\n\n");
		Event.printlnDump(buf.length, hexStr);

		/** 解析接收的数据 */
		ConnHandleResult tmpConnResult = new ConnHandleResult();

		int p = 0;
		byte type = buf[p++];
		byte eventCode = buf[p++];
		int dataLength = buf[p++];
		// System.out.println("-buflen:" + buf.length);
		if (Event.onDebugHead) {
			Event.println2x("-Type\t:", type);
			Event.println2x("-EventCode\t:", eventCode);
			Event.println2x("-Data Length\t:", dataLength);
		}
		boolean result;
		int nowStatus = -1;

		int event = Event.name(buf[p++], buf[p++]);
		switch (event) {
		case Event.GAP_HCI_ExtentionCommandStatus:
			result = Event.GAP_HCI_ExtentionCommandStatus_handle(buf, p,
					dataLength);
			break;
		case Event.GAP_DeviceInitDone:
			// 在一定时间内没有接收到success，DeviceInitResultListener show timeout
			result = Event.GAP_DeviceInitDone_handle(buf, p, dataLength);
			broadcast.sendBroadcast_DeviceInitResult(null, result);
			break;
		case Event.GAP_DeviceInformation:
			result = Event.GAP_DeviceInformation_handle(buf, p, dataLength);
			break;
		case Event.GAP_DeviceDiscoveryDone:
			DiscoverResult[] slaveDevs = Event.GAP_DeviceDiscoveryDone_handle(
					buf, p, dataLength);
			result = slaveDevs != null;

			if (slaveDevs != null && slaveDevs.length > 0) {
				Platform.getBle().broadcast.sendEnableLinkBroadcast(null,
						slaveDevs);
			}

			break;

		case Event.GAP_EstablishLink:
			result = Event.GAP_EstablishLink_handle(buf, p, dataLength,
					tmpConnResult);
			nowStatus = result ? STATE_CONNECTED : STATE_DISCONNECTED;
			// if (mClient != null) {
			// mClient.onConnectionStateChange(nowStatus);
			// mClient.setConnHandle(tmpConnResult);
			// }
			slaveManager.on_GAP_EstablishLink(nowStatus, tmpConnResult);
			break;
		case Event.GAP_TerminateLink:
			result = Event.GAP_TerminateLink_handle(buf, p, dataLength,
					tmpConnResult);
			nowStatus = result ? STATE_DISCONNECTED : STATE_CONNECTED;
			// if (mClient != null) {
			// mClient.onConnectionStateChange(nowStatus);
			// }
			slaveManager.on_GAP_TerminateLink(nowStatus, tmpConnResult);
			break;

		case Event.ATT_HandleValueNotification:
			byte[] data = Event.ATT_HandleValueNotification_handle(buf, p,
					dataLength, tmpConnResult);
			result = data != null;
			// if (mClient != null) {
			// mClient.onCharacteristicChanged(nowStatus(result), data);
			// }
			slaveManager.on_ATT_HandleValueNotification(tmpConnResult,
					nowStatus(result), data);
			break;
		case Event.ATT_ExecuteWriteRsp:
			result = Event.ATT_ExecuteWriteRsp_handle(buf, p, event,
					tmpConnResult);
			// if (mClient != null) {
			// mClient.onCharacteristicWrite(nowStatus(result));
			// }
			slaveManager.on_ATT_ExecuteWriteRsp(nowStatus(result),
					tmpConnResult);
			break;
		case Event.ATT_ReadRsp:
			byte[] readArr = Event.ATT_ReadRsp_handle(buf, p, dataLength,
					tmpConnResult);
			result = readArr != null;
			// if (mClient != null) {
			// mClient.onCharacteristicRead(nowStatus(result), readArr);
			// }
			slaveManager.on_ATT_ReadRsp(nowStatus(result), readArr,
					tmpConnResult);
			break;
		case Event.ATT_WriteRsp:
			result = Event.ATT_ExecuteWriteRsp_handle(buf, p, event,
					tmpConnResult);
			// if (mClient != null) {
			// mClient.onCharacteristicWrite(nowStatus(result));
			// }
			slaveManager.on_ATT_ExecuteWriteRsp(nowStatus(result),
					tmpConnResult);
			break;
		case Event.ATT_ReadByTypeRsp:
			byte[] readByTypeArr = Event.ATT_ReadByTypeRsp(buf, p, dataLength,
					tmpConnResult);
			result = readByTypeArr != null;
			slaveManager.on_ATT_ReadByTypeRsp(nowStatus(result), readByTypeArr,
					tmpConnResult);

		default:
			break;
		}

		int exhaustLen = 3 + dataLength;
		if (buf.length > exhaustLen) {
			int remainingLen = buf.length - exhaustLen;
			byte[] tailArr = new byte[remainingLen];
			System.arraycopy(buf, exhaustLen, tailArr, 0, remainingLen);
			distinguishRespondType(tailArr);
		}

	}

	private int nowStatus(boolean result) {
		return result ? STATE__SUCESS : STATE__ERROR;
	}

	public BleClient getClient() {
		return slaveManager.getSelectedClient();
	}

	public void release() {
		broadcast.unRegisterListeners();
		BleSlaveManager.onPopupAll();
		try {
			if (outputStream != null) {
				outputStream.close();
			}
			if (inputStream != null) {
				inputStream.close();
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (serialPort != null && portId != null
					&& portId.isCurrentlyOwned()) {
				serialPort.close();
			}
		}
	}

}
