package frame.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import storeroom.draw.Draw;

import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.BleSeriesInfo;
import model.BleSlaveManager;
import model.MultimeterReceivedData;
import control.BroadcastAgent;
import control.MainControl;

public class MultiListItem extends JPanel implements PropertyChangeListener {

	private JLabel titlelbl;
	private JLabel valuelbl;
	private JLabel funclbl;
	private JLabel modelbl;
	private JLabel unitlbl;

	JPanel north;
	JPanel center;
	JPanel west;
	JPanel east;

	Dimension itemDim = new Dimension(1000, 170);
	Dimension leftDim = new Dimension(130, 130);
	Dimension rightDim = new Dimension(200, 130);

	Font titleFt_single = new Font(Font.SANS_SERIF, Font.PLAIN, 16);
	Font valueFt_single = new Font(Font.SANS_SERIF, Font.PLAIN, 168);
	Font funcFt_single = new Font(Font.SANS_SERIF, Font.PLAIN, 22);
	Font unitFt_single = new Font(Font.SANS_SERIF, Font.PLAIN, 38);

	Font titleFt_multi = new Font(Font.SANS_SERIF, Font.PLAIN, 16);
	Font valueFt_multi = new Font(Font.SANS_SERIF, Font.PLAIN, 88);
	Font funcFt_multi = new Font(Font.SANS_SERIF, Font.PLAIN, 16);
	Font unitFt_multi = new Font(Font.SANS_SERIF, Font.PLAIN, 28);

	private BleAgent ag;
	private MainControl mainCtr;
	public String addr;
	boolean onS;

	public MultiListItem(MainControl mainCtr, String addr) {
		this.mainCtr = mainCtr;
		this.addr = addr;
		init();
		switchMulti_SingleLayout(onS);

		ag = Platform.getBle();
		ag.broadcast.addProperty(this);
	}

	private void init() {
		// setMaximumSize(itemDim);
		setLayout(new BorderLayout());
		createTitleView();
		createValueView();
		createFunc_ModeView();
		createUnitView();

		addBackgroundChangeListenner();

	}

	private void createTitleView() {
		// northPane
		north = new JPanel();
		// north.setBackground(Color.YELLOW);
		add(north, BorderLayout.NORTH);
		north.setLayout(new FlowLayout(FlowLayout.LEFT));
		JButton blueToothBtn = Draw.createRolloverBtn(MultiListItem.class,
				Draw.btIcon, Draw.delIcon);// new JButton("Bt");//TODO BT改为图背景
		north.add(blueToothBtn);
		titlelbl = new JLabel("BLE BDM2");
		titlelbl.setFont(titleFt_multi);
		titlelbl.setText(addr);
		north.add(titlelbl);

		blueToothBtn.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent arg0) {
				// onS = !onS;
				// switchMulti_SingleLayout(onS);
				BleClient mClient = BleSlaveManager.getClient(addr);
				if (mClient != null) {
					mClient.disconnect();
					Platform.getMain().onPopupItem(addr);
					BleSlaveManager.onPopupClient(mClient);
				}
			}
		});
	}

	private void createValueView() {
		// centerPane
		center = new JPanel();
		// center.setBackground(Color.YELLOW);
		add(center, BorderLayout.CENTER);

		valuelbl = new JLabel("347.6");
		// valuelbl.setFont(valueFt_multi);
		// center.add(valuelbl,BorderLayout.CENTER);
	}

	private void createFunc_ModeView() {
		// westPane
		west = new JPanel();
		west.setPreferredSize(leftDim);
		// west.setBackground(Color.YELLOW);
		west.setLayout(new BorderLayout());
		add(west, BorderLayout.WEST);

		JPanel westRP = new JPanel();
		west.add(westRP, BorderLayout.EAST);
		westRP.setLayout(new BoxLayout(westRP, BoxLayout.Y_AXIS));
		westRP.setOpaque(false);
		// westRP.setBackground(Color.red);
		JLabel gap1 = new JLabel(" ");
		westRP.add(gap1);
		funclbl = new JLabel("DCmV");
		// funclbl.setFont(funcFt_multi);
		westRP.add(funclbl);
		modelbl = new JLabel("AUTO");
		modelbl.setFont(funcFt_multi);
		westRP.add(modelbl);
	}

	private void createUnitView() {
		// eastPane
		east = new JPanel();
		east.setPreferredSize(rightDim);
		// east.setBackground(Color.YELLOW);
		east.setLayout(new BorderLayout());
		add(east, BorderLayout.EAST);

		JPanel eastSP = new JPanel();
		eastSP.setOpaque(false);
		// eastSP.setBackground(Color.red);
		east.add(eastSP, BorderLayout.SOUTH);
		unitlbl = new JLabel("mV");
		// unitlbl.setFont(unitFt_multi);
		eastSP.add(unitlbl);
	}

	private void addBackgroundChangeListenner() {
		addMouseListener(new MouseAdapter() {
			@Override
			public void mousePressed(MouseEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					@Override
					public void run() {
						mainCtr.setSelectItem(MultiListItem.this);
						mainCtr.updateCmdBtnsPane();
					}
				});
			}

		});

		// addMouseListener(new MouseAdapter() {
		// @Override
		// public void mousePressed(MouseEvent e) {
		// SwingUtilities.invokeLater(new Runnable() {
		// @Override
		// public void run() {
		// MultiListItem.this.requestFocus();
		// }
		// });
		// }
		//
		// });
		//
		// addFocusListener(new FocusListener() {
		// @Override
		// public void focusLost(FocusEvent arg0) {
		// selectBackground(false);
		// }
		//
		// @Override
		// public void focusGained(FocusEvent arg0) {
		// selectBackground(true);
		//
		// }
		// });
	}

	// private void selectBackground(boolean sel) {
	// Color backColor = sel ? Color.cyan : null;
	// north.setBackground(backColor);
	// center.setBackground(backColor);
	// west.setBackground(backColor);
	// east.setBackground(backColor);
	// }

	public void setSelect(boolean sel) {
		int slaveId = -1;
		if (sel) {
			slaveId = BleSlaveManager.setUserForcusSlave(addr);
			if (slaveId == -1) {
				System.err.println("MultiListItem  setUserForcusSlave Fail");
			}
		}

		Color backColor = null;
		if (sel && slaveId != -1) {
			backColor = Draw.lightBlueBg;
			// System.err.println(addr + "set backColor at: "+slaveId);
		}
		north.setBackground(backColor);
		center.setBackground(backColor);
		west.setBackground(backColor);
		east.setBackground(backColor);
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		String pn = evt.getPropertyName();
		Object o = evt.getNewValue();
		if (pn.equals(BroadcastAgent.BROADCAST_DATA) && o != null) {
			MultimeterReceivedData receivedData = (MultimeterReceivedData) o;
			// String value = receivedData.Index + ". " + receivedData.Func +
			// "  "
			// + receivedData.ValueString + receivedData.Unit;
			if (addr.equals(receivedData.mAddress)) {
				valuelbl.setText(receivedData.ValueString);
				funclbl.setText(receivedData.Func);
				modelbl.setText(receivedData.Mode);
				unitlbl.setText(receivedData.Unit);
			}
		}
		// else if (pn.equals(BroadcastAgent.BROADCAST_INTERACTION) && o !=
		// null) {
		// String msg = (String) o;
		// } else if (pn.equals(BroadcastAgent.BROADCAST_ENABLELINK) && o !=
		// null) {
		// }
	}

	public void switchMulti_SingleLayout(boolean onSingle) {
		if (onSingle) {
			doSinglePageLayout();
		} else {
			doMultiPageLayout();
		}

	}

	public MultiListItem doMultiPageLayout() {
		setMaximumSize(itemDim);
		titlelbl.setFont(titleFt_multi);
		valuelbl.setFont(valueFt_multi);
		funclbl.setFont(funcFt_multi);
		modelbl.setFont(funcFt_multi);
		unitlbl.setFont(unitFt_multi);

		center.setLayout(new FlowLayout());
		center.add(valuelbl);
		// updateUI();
		repaint();
		return this;
	}

	public MultiListItem doSinglePageLayout() {
		setMaximumSize(null);
		titlelbl.setFont(titleFt_single);
		valuelbl.setFont(valueFt_single);
		funclbl.setFont(funcFt_single);
		modelbl.setFont(funcFt_single);
		unitlbl.setFont(unitFt_single);

		center.setLayout(new BorderLayout());
		center.add(valuelbl, BorderLayout.CENTER);
		// updateUI();
		repaint();
		return this;
	}

}
