package frame.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.jfree.chart.ChartPanel;
import org.jfree.data.xy.XYSeries;

import control.BroadcastAgent;
import control.ChartControl;
import frame.MainFrame;
import frame.i18n.R;
import frame.i18n.StringRes;
import frame.utill.FadeIOShell;
import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.BleSlaveManager;
import model.MultimeterReceivedData;
import storeroom.draw.Draw;
import java.awt.Window;

public class ChartPage extends JPanel implements PropertyChangeListener {
	JList mList;
	JComboBox mDeviceList;
	JScrollPane scrollPane;
	// DefaultListModel listModel;
	DefaultComboBoxModel deviceListMode;
	ChartControl chartCtr;
	Window mContext;

	String mAddress = "";
	BleClient current;

	Dimension d = new Dimension(512, 576);
	boolean mPlayStatus = true;

	public ChartPage() {
		chartCtr = Platform.getMain().getChartCtr();
		// setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		setLayout(new BorderLayout());
		createWavePane();
		createListPane();
		BleAgent ag = Platform.getBle();
		ag.broadcast.addProperty(this);
	}

	private void createWavePane() {
		ChartPanel chart = chartCtr.getChartPanel();
		add(chart, BorderLayout.CENTER);
		// addComponentListener(new ComponentAdapter() {
		// @Override
		// public void componentResized(ComponentEvent e) {
		// }
		// });
	}

	private void createListPane() {
		JPanel listP = new JPanel();
		// listP.setPreferredSize(d);
		listP.setLayout(new BorderLayout());
		add(listP, BorderLayout.EAST);

		/** deviceListPane */
		JPanel deviceListP = new JPanel();
		deviceListP.setPreferredSize(new Dimension(250, 45));
		deviceListP.setBackground(Color.GRAY);
		listP.add(deviceListP, BorderLayout.NORTH);
		mDeviceList = new JComboBox();
		mDeviceList.addItemListener(new ItemListener() {

			@Override
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					updateDataList();
				}
			}

		});
		deviceListP.add(mDeviceList);

		// JToggleButton playBtn = new JToggleButton("Auto");
		// playBtn.setSelected(mPlayStatus);
		// deviceListP.add(playBtn);
		// playBtn.addActionListener(new ActionListener() {
		// @Override
		// public void actionPerformed(ActionEvent e) {
		// // mPlayStatus = !mPlayStatus;
		// }
		// });
		JMenuBar bar = new JMenuBar();
		bar.setSize(new Dimension(0, 30));
		deviceListP.add(bar);

		JMenu funcMenu = new JMenu(StringRes.getString(R.chart_funcBtn));
		bar.add(funcMenu);

		JMenuItem saveItem = new JMenuItem(StringRes.getString(R.chart_saveBtn));
		JMenuItem clearItem = new JMenuItem(StringRes.getString(R.chart_clearBtn));
		JCheckBoxMenuItem scrollItem = new JCheckBoxMenuItem(StringRes.getString(R.chart_autoScroll));
		scrollItem.setSelected(mPlayStatus);
		JCheckBoxMenuItem singletonItem = new JCheckBoxMenuItem(StringRes.getString(R.chart_singleton));
		singletonItem.setSelected(chartCtr.singletonAllow);
		funcMenu.add(saveItem);
		funcMenu.add(clearItem);
		funcMenu.add(scrollItem);
		funcMenu.add(singletonItem);
		saveItem.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				String osName = System.getProperty("os.name");
				String tips=StringRes.getString(R.chart_saveTips);
				if (osName.contains("10")) {
					FadeIOShell fs = new frame.utill.FadeIOShell();
					fs.prompt(tips, mContext);
				}

				chartCtr.saveReceiveData(current);
			}
		});
		clearItem.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				chartCtr.clearClient(current);
			}
		});
		scrollItem.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				mPlayStatus = !mPlayStatus;
			}
		});
		singletonItem.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				chartCtr.singletonAllow = !chartCtr.singletonAllow;
			}
		});

		/** valueListPane */
		// listModel = new DefaultListModel();
		mList = new JList();// listModel
		mList.setBackground(Draw.chartBg);
		scrollPane = new JScrollPane(mList);
		scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		scrollPane.setBorder(null);
		scrollPane.setOpaque(false);
		listP.add(scrollPane, BorderLayout.CENTER);

		// listModel.addElement("id.1");
		// listModel.addElement("id.2");
		// listModel.addElement("id.3");
		// listModel.removeElement("");//删除
	}

	public void initChartListModel() {
		chartCtr.initClientsSeries();

	}

	public void updateDeviceList() {
		deviceListMode = chartCtr.loadDeviceListMode();
		mDeviceList.setModel(deviceListMode);
	}

	public void updateDataList() {
		int sel = mDeviceList.getSelectedIndex();
		current = BleSlaveManager.getClient(sel);
		if (current == null)
			return;
		String name = current.getDevName();
		String addr = current.getAddress();
		if (addr != null) {
			mAddress = addr;
			// System.out.println("itemStateChanged.client:" + name + ",selStr:"
			// + mDeviceList.getSelectedItem());

			DefaultListModel datalist = chartCtr.getDataModel(addr);
			if (datalist != null)
				mList.setModel(datalist);
		}
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		String pn = evt.getPropertyName();
		Object o = evt.getNewValue();
		if (o == null)
			return;
		if (pn.equals(BroadcastAgent.BROADCAST_DATA)) {
			MultimeterReceivedData receivedData = (MultimeterReceivedData) o;
			// String addr = receivedData.mAddress;
			// if (mAddress.equals(addr)) {
			receiveDataAddToDataList(receivedData);
			// }
		}
	}

	private void receiveDataAddToDataList(MultimeterReceivedData data) {

		if (data.Index == -1) {
			MSG_ERROR("Handle ACTION_DATA_RECEIVED,invalid Index");
			return;
		}

		XYSeries series = chartCtr.getXYSeries(data.mAddress);
		// List<HashMap<String, Object>> datalist = chartCtr
		// .getDataList(clientAddress);
		// SimpleAdapter adapter = getSimpleAdapter(clientAddress);

		final DefaultListModel datalist = chartCtr.getDataModel(data.mAddress);
		if (datalist == null || series == null) {// || adapter == null
			MSG_ERROR("Handle ACTION_DATA_RECEIVED, series/datalist/adapter not found");
		} else {
			series.add(data.Index, data.Value);
			chartCtr.repaintChartPanel();

			datalist.addElement(chartCtr.getFormateData(data));
			// adapter.notifyDataSetChanged();

			if (mPlayStatus && mAddress.equals(data.mAddress)) {

				mList.validate();
				String addr = data.mAddress;
				mList.ensureIndexIsVisible(data.Index);
				mList.repaint();
			}

			chartCtr.setLegendTitle(series, data.Unit);// TODO 优化,不必每次设置
			chartCtr.keepSingleton(datalist, data);// TODO 优化,不必每次getClient
		}

		// if (onAutoScroll) {
		// currentListView.setSelection(currentListView.getCount());
		// }

	}
	
	public void setWinContext(Window mContext){
		this.mContext=mContext;
	}

	private final String TAG = "ChartPage";

	private void MSG_ERROR(String msg) {
		System.err.println("[ " + TAG + " ] :: Error :: " + msg);
	}

	private void MSG_DEBUG(String msg) {
		System.out.println("dbg[ " + TAG + " ] $$$:: " + msg);
	}

}
