package frame.i18n;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringRes {
	private static final String BUNDLE_NAME = "frame.i18n.strings"; //$NON-NLS-1$

	private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle
			.getBundle(BUNDLE_NAME);

	private StringRes() {
	}

	public static void update() {
		RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
	}

	public static ResourceBundle getBundle() {
		return RESOURCE_BUNDLE;
	}

	public static String getString(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}

}
