package frame;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import kernal.BleAgent;
import main.Platform;
import model.DiscoverResult;
import control.BroadcastAgent;
import control.MainControl;
import frame.i18n.R;
import frame.i18n.StringRes;

public class ScanDialog extends JDialog implements PropertyChangeListener {

	private BleAgent ag;
	private MainControl mc;
	private JProgressBar bar;
	private JTable listP;
	private JButton connBtn;
	// private DiscoverResult[] slaveDevs;
	private List<DiscoverResult> slaveDevs = new ArrayList<DiscoverResult>();

	private static ScanDialog sDlg;

	public static ScanDialog getInstance(JFrame main) {
		if (sDlg == null)
			sDlg = new ScanDialog(main);
		return sDlg;
	}

	private ScanDialog(JFrame main) {
		super(main);
		setSize(new Dimension(500, 299));
		setLocationRelativeTo(null);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				sDlg = null;
			}
		});
		initDialog();

		ag = Platform.getBle();
		mc = Platform.getMain();
		ag.broadcast.addProperty(this);
	}

	private void initDialog() {
		setTitle(StringRes.getString(R.scanDlg_title));// "Scan Devices"
		setLayout(new BorderLayout());
		createNorthPane();
		createListPane();
		setVisible(false);
	}

	public void showDlg() {
		updateWhenScanBegin();
		setVisible(true);
		ag.discoveryRequest();
	}

	private void createNorthPane() {
		JPanel northP = new JPanel();
		add(northP, BorderLayout.NORTH);

		northP.setLayout(new FlowLayout(FlowLayout.RIGHT));
		connBtn = new JButton(StringRes.getString(R.scanDlg_connect));// "Connect"
		northP.add(connBtn);

		connBtn.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent arg0) {
				// scanedResultsAddToJTableTest();
				if (slaveDevs != null) {
					int row = listP.getSelectedRow();
					row = row < 0 ? 0 : row;
					DiscoverResult selDev = slaveDevs.get(row);// [row];//
					boolean success = ag.linkRequest(selDev, mc.clientCall);
					if (!success) {
						JOptionPane.showMessageDialog(ScanDialog.this, StringRes.getString(R.scanDlg_hadConnected));
					}
				}
			}

		});

		bar = new JProgressBar();
		bar.setPreferredSize(new Dimension(80, 15));
		bar.setOrientation(JProgressBar.HORIZONTAL);
		bar.setIndeterminate(true);
		northP.add(bar);
	}

	private void createListPane() {
		listP = new JTable(new DefaultTableModel() {
			public int getColumnCount() {
				return 1;
			}

			public int getRowCount() {
				return 10;
			}

			@Override
			public String getColumnName(int column) {
				switch (column) {
				case 0:
					return " ";
				case 1:
					return " ";
				default:
					return "";
				}
			}
		});
		listP.setRowHeight(35);
		listP.getColumnModel().getColumn(0).setPreferredWidth(400);
		JScrollPane scrollP = new JScrollPane(listP);
		add(scrollP, BorderLayout.CENTER);
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		String pn = evt.getPropertyName();
		Object o = evt.getNewValue();
		if (o == null)
			return;
		if (pn.equals(BroadcastAgent.BROADCAST_SCANDEVICEINFO)) {
			DiscoverResult r = (DiscoverResult) o;
//			System.out.println("ScanDialog#" + r);
			boolean hadResult = false;
			for (DiscoverResult res : slaveDevs) {
				if (res.samewith(r)) {
					hadResult = true;
				}
			}
			if (!hadResult) {
				slaveDevs.add(r);
				int rows = slaveDevs.size() - 1;

				listP.setValueAt(r, rows, 0);
				listP.validate();
			}

		} else if (pn.equals(BroadcastAgent.BROADCAST_ENABLELINK)) {
			// slaveDevs = (DiscoverResult[]) o;
			// for (int i = 0, l = slaveDevs.length; i < l; i++) {
			// listP.setValueAt(slaveDevs[i], i, 0);
			// }
			// // listP.repaint();
			// listP.validate();
			// // listP.updateUI();
			//
			// for (DiscoverResult s : slaveDevs) {
			// System.err.println("ScanDialog: " + s);
			// }

			updateWhenScanDone();
		}
	}

	private void updateWhenScanDone() {
		connBtn.setVisible(true);
		bar.setVisible(false);
	}

	private void updateWhenScanBegin() {
		connBtn.setVisible(false);
		bar.setVisible(true);
	}

	@Deprecated
	private void scanedResultsAddToJTableTest() {
		DiscoverResult a = new DiscoverResult();
		a.addrName = "dev1";
		DiscoverResult b = new DiscoverResult();
		b.addrName = "dev2";

		DiscoverResult[] slaveDevs = { a, b };
		DefaultTableModel model = (DefaultTableModel) listP.getModel();

		for (int i = 0, l = slaveDevs.length; i < l; i++) {

			model.setValueAt(slaveDevs[i], i, 0);
		}
		// listP.repaint();
		listP.validate();
		// listP.updateUI();
	}

	public static void main(String[] args) {
		ScanDialog d = ScanDialog.getInstance(null);
		d.showDlg();
	}
}
