package frame;

/****************************************** * 程序文件名称：SendComm.java * 功能：从串行口COM1中发送数据  ******************************************/
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

//import javax.comm.*;

public class S_Frame extends Frame implements Runnable, ActionListener {

	private static CommPortIdentifier portId;/* 检测系统中可用的通讯端口类 */
	// private Enumeration portList;/* Enumeration 为枚举型类,在util中 */
	private OutputStream outputStream;/* RS-232的串行口 */
	private SerialPort serialPort;
	private Thread readThread;

	Panel btnPane = new Panel();
	TextField in_message = new TextField("");// 打开COM1,波特率9600,数据位8,停止位1
	TextArea out_message = new TextArea();
	Button btnOpen = new Button("OpenComm SendData");// 打开串口, 发送数据
	Button btnClose = new Button("CloseComm");// 关闭串口, 停止发送数据
	private byte data[] = new byte[10240];// { (byte)2, (byte)1 };//
	/* 设置判断是否要关闭串口的标志 */
	boolean onClose = false;

	/* 安排窗体 */
	S_Frame() {
		super("串口发送数据");
		setSize(200, 200);
		setVisible(true);
		add(out_message, "Center");
		add(btnPane, "North");
		add(in_message, "South");

		btnPane.add(btnOpen);
		btnPane.add(btnClose);

		btnOpen.addActionListener(this);
		btnClose.addActionListener(this);
	}

	public void actionPerformed(ActionEvent event) {
		if (event.getSource() == btnClose) {

			onClose = true; // 用于中止线程的run()方法
			in_message.setText(serialPort + "串口关闭,停止发送数据.");
			serialPort.close(); // 关闭串口

		} else {
			onClose = false;
			/* 从文本区按字节读取数据 */
			data = out_message.getText().getBytes();
			/* 打开串口 */
			start();
		}
	}

	/* 打开串口,并调用线程发送数据 */
	public void start() {
		/* 获取系统中所有的通讯端口 */
		Enumeration portList = CommPortIdentifier.getPortIdentifiers();
		// TODO 做成下拉框显示出来，等待用户选择一个选项。

		/* 用循环结构找出串口 */
		// TODO 把用户选中选项当索引，在循环结构中找出串口。

		while (portList.hasMoreElements()) { /* 强制转换为通讯端口类型 */
			portId = (CommPortIdentifier) portList.nextElement();
			if (portId.getPortType() == CommPortIdentifier.PORT_SERIAL) {

				if (portId.getName().equals("COM101")) {
					/* 打开串口 */
					try {
						serialPort = (SerialPort) portId.open("MyWriteComm", 2000);
					} catch (PortInUseException e) {
						System.err.println("portId.open PortInUseException ");
					}
					/* 设置串口输出流 */
					try {
						outputStream = serialPort.getOutputStream();
					} catch (IOException e) {
						System.err.println("getOutputStream outputStream ");
					}
					break;
				} else
					System.out.println(portId.getName());
			}
		}
		// TODO 若找不到串口，停止执行
		if (serialPort == null) {
			in_message.setText("无法找到合适端口");
			return;
		}
		in_message.setText(serialPort.getName() + "串口已经打开,正在每1秒钟发送一次数据.....");

		/* 设置串口通讯参数 */
		try {
			serialPort.setSerialPortParams(9600, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
		} catch (UnsupportedCommOperationException e) {
			System.err.println("Set UnsupportedCommOperationException ");
		}

		/* 调用线程发送数据 */
		try {
			readThread = new Thread(this); // 线程负责每发送一次数据，休眠2秒钟
			readThread.start();
		} catch (Exception e) {
		}
	}

	@Override
	public void run() {

		while (!onClose) {
			/* 发送数据流(将数组data[]中的数据发送出去) */
			try {
				outputStream.write(data);
				outputStream.flush();
				System.out.println(new String(data));
			} catch (IOException e) {
				e.printStackTrace();
				System.err.println("write(data) IOException ");
			}
			/* 发送数据后休眠2秒钟,然后再重发 */
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
				// System.err.println("sleep InterruptedException ");
			}
		}

	}

	public static void main(String args[]) {
		S_Frame S_win = new S_Frame();
		S_win.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		S_win.pack();
	}
}
