package frame;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import frame.i18n.R;
import frame.i18n.StringRes;

import kernal.BleAgent;
import kernal.BleClient;
import kernal.Command;
import kernal.HexCmds;

import main.Platform;
import model.BleSlaveManager;

public class RecordSetDialog extends JDialog {
	BleAgent ag;

	private static RecordSetDialog setDlg;

	public static RecordSetDialog getInstance(JFrame main) {
		if (setDlg == null)
			setDlg = new RecordSetDialog(main);
		return setDlg;
	}

	public RecordSetDialog(JFrame main) {
		super(main);
		setSize(new Dimension(500, 299));
		setLocationRelativeTo(null);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				setDlg = null;
			}
		});
		initDialog();

		ag = Platform.getBle();

	}

	JLabel tipsLbl, time;
	JTextField intervalTf, countTf;
	JButton startBtn;
	boolean hasStartToRecord;

	private void initDialog() {
		Container c = getContentPane();
		setLayout(new BoxLayout(c, BoxLayout.Y_AXIS));

		JPanel tipsP = new JPanel();
		JPanel intervalP = new JPanel();
		JPanel countP = new JPanel();
		JPanel costtimeP = new JPanel();
		JPanel btnP = new JPanel();

		tipsLbl = new JLabel(StringRes.getString(R.recordSetDlg_tips1));
		tipsP.add(tipsLbl);

		JLabel intervalLbl = new JLabel(
				StringRes.getString(R.recordSetDlg_interval));
		// "Rcecord interval"
		intervalP.add(intervalLbl);
		intervalTf = new JTextField();
		intervalTf.setColumns(20);
		intervalP.add(intervalTf);
		JLabel unitLbl = new JLabel(StringRes.getString(R.recordSetDlg_sec));
		// "Sec"
		intervalP.add(unitLbl);

		JLabel countLbl = new JLabel(StringRes.getString(R.recordSetDlg_counts));
		// "Record counts"
		countP.add(countLbl);
		countTf = new JTextField();
		countTf.setColumns(11);
		countP.add(countTf);
		JLabel maxLbl = new JLabel(StringRes.getString(R.recordSetDlg_max));
		// "Maximum is 10,000"
		countP.add(maxLbl);

		JLabel costTimeLbl = new JLabel(
				StringRes.getString(R.recordSetDlg_costTime));
		// "Record will cost time about:"
		costtimeP.add(costTimeLbl);
		time = new JLabel();
		costtimeP.add(time);

		startBtn = new JButton(StringRes.getString(R.recordSetDlg_start));
		// /"start offline record"
		btnP.add(startBtn);
		startBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if (!startBtn.getText().equals(
						StringRes.getString(R.RecordSetDlg_back))) {
					tryToSetCmd();
				} else {
					dismissDlg();
				}
			}
		});

		add(tipsP);
		add(intervalP);
		add(countP);
		add(costtimeP);
		add(btnP);

		initValue();

	}

	public void showDlg() {
		setVisible(true);
	}

	private void initValue() {
		hasStartToRecord = false;
		intervalTf.setText("1");
		countTf.setText("1000");

	}

	private void dismissDlg() {
		this.dispose();
		setDlg = null;
	}

	private void tryToSetCmd() {
		BleClient mClient = ag.getClient();
		if (mClient == null) {
			MSG_ERROR("onClick.mClient == null ");
			return;
		}

		if (hasStartToRecord) {
			dispose();
		} else {

			int iv = 0, ln = 0;
			try {
				iv = Integer.parseInt(intervalTf.getText());
			} catch (Exception e) {
				iv = 1;
			}

			try {
				ln = Integer.parseInt(countTf.getText());
			} catch (Exception e) {
				ln = 10;
			}
			// System.err.println("interval:" + iv + ",len:" + ln);
			if (iv == 0 || ln == 0) {
				// Toast.makeText(this,
				// getResources().getString(BIGGER_THAN_ZERO),
				// Toast.LENGTH_SHORT).show();
				JOptionPane.showMessageDialog(this,
						"Value need to be bigger than zero");

			} else {

				sendSettingCmd_disconnect(mClient, iv, ln);
				highlightTheDisconnected();

				hasStartToRecord = true;
				startBtn.setText(StringRes.getString(R.RecordSetDlg_back));
				// "back"
			}
		}

	}

	private void sendSettingCmd_disconnect(final BleClient mClient, int iv,
			int ln) {
		HexCmds lib = new HexCmds();
		byte[] cmds = lib.getRecordCmd(iv, ln);
		if (mClient != null) {
			// boolean support =
			// bleclient.getBleSeries().isSurportOfflineDate();
			// if (support) {
			// mClient.sendCommand(MultimeterClient.WRITE_STARTRECORD,
			// lib.getDateCmd());
			// mClient.writeCharacteristic(Command.F1_RW_HANDLE,
			// lib.getDateCmd());
			// }

			// mClient.sendCommand(MultimeterClient.WRITE_STARTRECORD,
			// cmds);
			mClient.writeCharacteristic(Command.F1FF, cmds);

			// TODO 提示
			// Toast.makeText(
			// this,
			// getResources().getString(
			// R.string.record_setting_toast_start), 0).show();

			final Timer timer = new Timer();
			TimerTask task = new TimerTask() {
				@Override
				public void run() {
					mClient.disconnect();
					Platform.getMain().onPopupItem(mClient.getAddress());
					BleSlaveManager.onPopupClient(mClient);
					timer.cancel();
				}
			};
			timer.schedule(task, 1000);

		}
	}

	private void highlightTheDisconnected() {
		tipsLbl.setForeground(Color.RED);
		tipsLbl.setText(StringRes.getString(R.recordSetDlg_tips2));
	}

	private void MSG_ERROR(String msg) {
		System.err.println("err:" + msg);
	}

	public static void main(String[] args) {
		new RecordSetDialog(null).show();
	}
}
