package frame;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import kernal.BleAgent;
import kernal.BleClient;
import kernal.Command;
import main.Platform;
import model.BleClientGattCallback;
import model.BleSlaveManager;
import model.ConnHandleResult;
import model.DiscoverResult;
import model.MultimeterReceivedData;
import control.BroadcastAgent;

//import javax.comm.*;

public class R_Frame extends Frame implements PropertyChangeListener {

	TextArea commtxt = new TextArea("order display");// 指令收发打印
	TextField readtxt = new TextField("show multimeter data here\n");// 这里显示万用表的数据

	BleAgent ag;

	Button btnLink;
	JComboBox discoverResultCcb;
	DiscoverResult[] slaveDevs;

	/* 建立窗体 */
	public R_Frame() {
		super("PC BLE Multimeter");
		setPreferredSize(new Dimension(600, 400));
		// setLocationRelativeTo(null);
		setLayout(new BorderLayout());
		setVisible(true);

		JPanel north_btnPane = initNorthPane();
		JPanel center_Pane = initCenterPane();
		JPanel south_btnPane = initSouthPane();
		// 容器组装
		add(north_btnPane, BorderLayout.NORTH);
		add(center_Pane, BorderLayout.CENTER);
		add(south_btnPane, BorderLayout.SOUTH);

		// 控制类
		ag = Platform.getBle();
		ag.broadcast.addProperty(this);
	}

	public void release() {
		ag.release();
	}

	public static void main(String args[]) {
		/* 实例化接收串口数据的窗体类 */
		R_Frame R_win = new R_Frame();
		/* 定义窗体适配器的关闭按钮功能 */
		R_win.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		R_win.pack();
	}

	private JPanel initNorthPane() {
		Button btnOpen = new Button("OpenComm");
		btnOpen.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				/* 点击按扭所触发的事件：打开串口,并监听串口. */
				ag.openSeriesPort();
			}
		});
		Button btnDiscover = new Button("Discover");
		btnDiscover.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				ag.discoveryRequest();
			}
		});
		discoverResultCcb = new JComboBox();

		btnLink = new Button("Link");
		btnLink.setEnabled(false);
		btnLink.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				// DiscoverResult selDev=new DiscoverResult();
				//
				// byte[] slaveAddr = { (byte) 0x2C, (byte) 0x37, (byte) 0x22,
				// (byte) 0xF3, (byte) 0x7B, (byte) 0x98 };
				// selDev.addr=slaveAddr;
				// selDev.addrName="987BF322372C";
				if (slaveDevs != null) {
					DiscoverResult selDev = slaveDevs[discoverResultCcb.getSelectedIndex()];
					ag.linkRequest(selDev, clientCall);
				}
			}
		});

		Button btnTerminate = new Button("Terminate");
		btnTerminate.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				DiscoverResult sel = (DiscoverResult) discoverResultCcb.getSelectedItem();
				System.err.println("getItem:" + sel.addrName);
				// String n = slaveDevs[sel].addrName;
				BleClient client = BleSlaveManager.getClient(sel.addrName);
				ag.terminateLinkRequest(client);
			}
		});

		Button btnClear = new Button("Clear");
		btnClear.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				commtxt.setText("");
				// readtxt.setText("");
			}
		});

		JPanel north_btnPane = new JPanel();
		north_btnPane.add(btnOpen);
		north_btnPane.add(btnDiscover);
		north_btnPane.add(discoverResultCcb);
		north_btnPane.add(btnLink);
		north_btnPane.add(btnTerminate);
		north_btnPane.add(btnClear);
		return north_btnPane;
	}

	private JPanel initCenterPane() {
		JPanel centerPane = new JPanel();
		centerPane.setLayout(new BorderLayout());

		centerPane.add(commtxt, BorderLayout.CENTER);
		centerPane.add(readtxt, BorderLayout.NORTH);

		return centerPane;

	}

	private JPanel initSouthPane() {
		// SouthPane存放控制按钮
		JPanel south_btnPane = new JPanel();
		JButton holdBtn = new JButton("Light/Hold");
		south_btnPane.add(holdBtn);
		holdBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				byte[] value = { 0x03, 0x01 };
				BleClient c = ag.getClient();
				if (c != null) {
					c.writeCharacteristic(Command.F3FF, value);
				}
			}
		});
		JButton selBtn = new JButton("Select");
		south_btnPane.add(selBtn);
		selBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				byte[] value = { 0x01, 0x01 };
				BleClient c = ag.getClient();
				if (c != null) {
					c.writeCharacteristic(Command.F3FF, value);
				}
			}
		});
		JButton rangeBtn = new JButton("Range");
		south_btnPane.add(rangeBtn);
		rangeBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				byte[] value = { 0x02, 0x01 };
				BleClient c = ag.getClient();
				if (c != null) {
					c.writeCharacteristic(Command.F3FF, value);
				}
			}
		});
		JButton hzBtn = new JButton("Hz/Duty");
		south_btnPane.add(hzBtn);
		hzBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				byte[] value = { 0x05, 0x01 };
				BleClient c = ag.getClient();
				if (c != null) {
					c.writeCharacteristic(Command.F3FF, value);
				}
			}
		});
		JButton maxminBtn = new JButton("Max/Min");
		south_btnPane.add(maxminBtn);
		maxminBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				byte[] value = { 0x06, 0x01 };
				BleClient c = ag.getClient();
				if (c != null) {
					c.writeCharacteristic(Command.F3FF, value);
				}
			}
		});
		JButton relBtn = new JButton("Rel/BLE");
		south_btnPane.add(relBtn);
		relBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				byte[] value = { 0x04, 0x01 };
				BleClient c = ag.getClient();
				if (c != null) {
					c.writeCharacteristic(Command.F3FF, value);
				}
			}
		});

		return south_btnPane;
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		String pn = evt.getPropertyName();
		Object o = evt.getNewValue();
		if (pn.equals(BroadcastAgent.BROADCAST_DATA) && o != null) {
			MultimeterReceivedData receivedData = (MultimeterReceivedData) o;

			String value = receivedData.Index + ". " + receivedData.Func + "  " + receivedData.ValueString
					+ receivedData.Unit;
			readtxt.setText(value);
		} else if (pn.equals(BroadcastAgent.BROADCAST_INTERACTION) && o != null) {
			String msg = (String) o;
			commtxt.append(msg);
		} else if (pn.equals(BroadcastAgent.BROADCAST_ENABLELINK) && o != null) {
			slaveDevs = (DiscoverResult[]) o;
			discoverResultCcb.setModel(new DefaultComboBoxModel(slaveDevs));
			btnLink.setEnabled(true);

			for (DiscoverResult s : slaveDevs) {
				System.err.println("R_Frame:  " + s);
			}

			pack();
		}
	}

	private BleClientGattCallback clientCall = new BleClientGattCallback() {
		public void onConnectionStateChange(int newState) {
			switch (newState) {
			case BleAgent.STATE_CONNECTED:
				System.err.println(" #######CONNECTED");
				break;
			case BleAgent.STATE_DISCONNECTED:
				System.err.println(" DISCONNECTED");
				break;
			default:
				break;
			}

		}

		public void onCharacteristicRead(int status, byte handle, byte[] value) {
			System.err.println("onRead.handle:" + handle);
			for (byte b : value) {
				System.err.print(b + ":");
			}
			System.err.println();
		}

		public void onCharacteristicWrite(int status, byte handle) {
			System.err.println("onWrite.handle:" + handle + ",status:" + status);
		}

		public void onCharacteristicChanged(ConnHandleResult tmpConnResult, int status, byte[] data) {
			switch (status) {
			case BleAgent.STATE__SUCESS:
				System.err.println(
						" STATE__SUCESS  @  connID:" + tmpConnResult.ConnID + ",addr:" + tmpConnResult.Address);
				break;
			case BleAgent.STATE__ERROR:
				System.err.println(" STATE__ERROR");
				break;
			default:
				break;
			}
		}
	};
}
