package frame;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

import storeroom.util.SerialPortUtil;

import control.DeviceInitResultListener;
import frame.i18n.R;
import frame.i18n.StringRes;

import kernal.BleAgent;
import main.Platform;

public class PortSettingDlg extends JDialog {

	DeviceInitResultListener initListener;

	public PortSettingDlg(DeviceInitResultListener listener) {
		this.initListener = listener;

		setSize(new Dimension(300, 250));
		setLocationRelativeTo(null);
		setAlwaysOnTop(true);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);

		initDlg();
		new Thread(new Runnable() {

			@Override
			public void run() {
				List<String> list = SerialPortUtil.loadAvailablePort();
				portCbb.setModel(new DefaultComboBoxModel(list.toArray()));
			}
		}).start();
		setModal(true);
	}

	JComboBox portCbb;

	public void initDlg() {
		setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
		JPanel p1 = new JPanel();
		JPanel p2 = new JPanel();
		JPanel p3 = new JPanel();
		add(p1);
		add(p2);
		add(p3);

		JLabel portLbl = new JLabel(
				StringRes.getString(R.portSettingDlg_port));
		portCbb = new JComboBox();
		portCbb.setPreferredSize(new Dimension(150, 25));
		p1.add(portLbl);
		p1.add(portCbb);

		JLabel baudLbl = new JLabel(
				StringRes.getString(R.portSettingDlg_baud));
		JComboBox baudCbb = new JComboBox();
		baudCbb.setPreferredSize(new Dimension(150, 25));
		Integer[] baudArr = { 115200, 57600, 38400 };
		baudCbb.setModel(new DefaultComboBoxModel(baudArr));
		baudCbb.setEnabled(false);
		p2.add(baudLbl);
		p2.add(baudCbb);

		JButton okBtn = new JButton(StringRes.getString(R.btn_ok));
		// JButton cancelBtn = new JButton("Cancel");
		p3.add(okBtn);
		// p3.add(cancelBtn);
		okBtn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				/** 端口先选择再启动控制类打开端口 */
				String selectPort = portCbb.getSelectedItem().toString();
				PortSettingDlg.this.dispose();

				BleAgent ag = Platform.getBle();
				ag.setUserSelectedPort(selectPort);
				ag.openSeriesPort();
				initListener.startListenInitResult();

			}
		});
		// cancelBtn.addActionListener(new ActionListener() {
		// @Override
		// public void actionPerformed(ActionEvent e) {
		// PortSettingDlg.this.dispose();
		// JOptionPane.showMessageDialog(PortSettingDlg.this,
		// "Start Failed");
		// }
		// });

		setVisible(true);

	}

	public static void main(String[] args) {
		new PortSettingDlg(null);
	}

}
