package control;

import java.util.ArrayList;

import kernal.BleAgent;
import kernal.BleClient;
import kernal.Command;
import model.BleClientGattCallback;
import model.BleSeriesInfo;
import model.BleSlaveManager;
import model.ConnHandleResult;
import frame.MainFrame;
import frame.view.MultiListItem;

public class MainControl {
	private ArrayList<MultiListItem> mits = new ArrayList<MultiListItem>();
	private ArrayList<MultiListItem> sits = new ArrayList<MultiListItem>();
	private MainFrame main;
	private ChartControl chartCtr;

	public MainControl() {
		chartCtr = new ChartControl();
	}

	public MainFrame launchMainFrame() {
		if (main == null)
			main = new MainFrame();
		return main;
	}

	public ChartControl getChartCtr() {
		return chartCtr;
	}

	public void setSelectItem(MultiListItem selected) {
		for (MultiListItem it : mits) {
			boolean isone = it.addr.equals(selected.addr);
			it.setSelect(isone);// it == selected
		}
		for (MultiListItem it : sits) {
			boolean isone = it.addr.equals(selected.addr);
			it.setSelect(isone);
		}

	}

	public void updateCmdBtnsPane() {
		BleClient mClient = BleSlaveManager.getSelectedClient();
		int seriesId = BleSeriesInfo.NONMATCH;
		if (mClient != null)
			seriesId = mClient.getBleSeries().getSeriesID();
		main.initSouthPane(seriesId);
	}

	public boolean onCreateItem(String addr) {
		// for (BleClient c : BleSlaveManager.slaves) {
		// if (c.getAddress().equalsIgnoreCase(addr))
		// return false;
		// }
		MultiListItem mit = new MultiListItem(this, addr);
		MultiListItem sit = new MultiListItem(this, addr);
		mits.add(mit);
		sits.add(sit);
		main.addItem(mit, sit);
		return true;
	};

	public void onPopupItem(String addr) {
		MultiListItem mit = null;
		MultiListItem sit = null;
		for (MultiListItem it : mits) {
			if (it.addr.equals(addr)) {
				mits.remove(it);
				mit = it;
				break;
			}
		}
		for (MultiListItem it : sits) {
			if (it.addr.equals(addr)) {
				sits.remove(it);
				sit = it;
				break;
			}
		}
		main.removeItem(mit, sit);

	}

	public static final byte  selectPress = 1, rangePress = 2,
			holdPress = 3, relPress = 4, hzPress = 5, maxPress = 6,
			allPress = 7, longPress = 0,pressOnce = 1;

	public static void cWriteCmd(BleClient mClient, byte funcId,
			boolean isLongPress) {
		if (mClient != null) {
			byte b1 = funcId;// 大类别
			byte b2 = (byte) (isLongPress ? longPress : pressOnce);// 小档位脉冲增量
			byte[] out = { b1, b2 };
			try {
				Thread.sleep(200);
				mClient.writeCharacteristic(Command.F3FF, out);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}

		}
	}

	public BleClientGattCallback clientCall = new BleClientGattCallback() {
		public void onConnectionStateChange(String mAddress, int newState) {
			switch (newState) {
			case BleAgent.STATE_CONNECTED:
				System.err.println("#######CONNECTED:  " + mAddress);
				onCreateItem(mAddress);
				chartCtr.initClientDataModel(BleSlaveManager
						.getClient(mAddress));
				break;
			case BleAgent.STATE_DISCONNECTED:
				System.err.println("#######DISCONNECTED:  " + mAddress);
				onPopupItem(mAddress);
				BleSlaveManager.onPopupClient(BleSlaveManager
						.getClient(mAddress));
				chartCtr.removeSeries(mAddress);
				break;
			default:
				break;
			}

		}

		public void onCharacteristicRead(int status, byte handle, byte[] value) {
			// System.err.println("onRead.handle:" + handle);
			// for (byte b : value) {
			// System.err.print(b + ":");
			// }
			// System.err.println();
		}

		public void onCharacteristicWrite(int status, byte handle) {
			// System.err.println("BleClientGattCallback.onWrite.handle:" +
			// handle
			// + ",status:" + status);// success==2
		}

		public void onCharacteristicChanged(ConnHandleResult tmpConnResult,
				int status, byte[] data) {
			switch (status) {
			case BleAgent.STATE__SUCESS:
				// System.err.println("MainCtr.onCharacteristicChanged STATE__SUCESS  @  connID:"
				// + tmpConnResult.ConnID + ",addr:"
				// + tmpConnResult.getAddress());

				// TODO 从tmpConnResult.Address找到对应MultiListItem,更新value
				break;
			case BleAgent.STATE__ERROR:
				System.err
						.println("MainCtr.onCharacteristicChanged  STATE__ERROR");
				break;
			default:
				break;
			}
		}

		public void onDeviceSeriesRead(int serieid) {
			updateCmdBtnsPane();
			//System.err.println("MainControl #serieid:"+serieid);
		}
	};

}
