package control;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;

import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;

import model.BleSlaveManager;
import model.MultimeterReceivedData;
import model.chartModel.CreateJChartLine;

import kernal.BleClient;

public class ChartControl {

	public static final String DEVICE_NAME = "devInfo_name";
	public static final String DEVICE_ADDRESS = "devInfo_addr";

	private final String TAG = "ChartControl";
	private final Color defaultColor = Color.YELLOW;
	public final Color COLOR_MATRIX[] = { defaultColor, Color.RED, Color.GREEN,
			Color.MAGENTA, Color.WHITE };

	private List<HashMap<String, Object>> mSeriesList = new ArrayList<HashMap<String, Object>>();
	private CreateJChartLine jchart;
	public boolean singletonAllow = false;

	/** 大檔位轉動，清除列表之前接受的數據 */
	public void keepSingleton(DefaultListModel series,
			MultimeterReceivedData data) {
		int idx = data.Index - 1;
		if (idx >= 0 && idx < series.getSize()) {
			BleClient client = BleSlaveManager.getClient(data.mAddress);
			if (client != null) {
				MultimeterReceivedData lastData = client.getReceivedData().get(
						idx);

				if (!lastData.UnitType.equals(data.UnitType)) {
					client.needSingleton = true;
				}
				if (singletonAllow && client.needSingleton) {
					client.needSingleton = false;
					clearClient(client);
				}
			}
		}
	}

	public ChartControl() {
		jchart = new CreateJChartLine();
	}

	public ChartPanel getChartPanel() {
		ChartPanel cp = jchart.getChartPanel();

		return cp;
	}

	public void repaintChartPanel() {
		ChartPanel cp = getChartPanel();
		if (cp != null) {
			cp.revalidate();
			cp.repaint();
		}
	}

	public void initClientsSeries() {
		List<BleClient> clientList = BleSlaveManager.getClients();

		if (clientList != null) {
			for (int i = 0; i < clientList.size(); i++) {
				BleClient client = clientList.get(i);

				initClientDataModel(client);
				// initClientsSeriesDataModel(client);

				// if (client == null)
				// continue;
				// if (!addSeries(client.getAddress())) {
				// MSG_ERROR("onCreate, addSeries fail, Client: "
				// + client.getAddress());
				// }
			}
		} else {
			// 装载模拟数据
		}
	}

	public void initClientDataModel(BleClient client) {
		if (client != null) {
			DefaultListModel datalist = getDataModel(client.getAddress());
			if (datalist == null) {
				addSeries(client.getAddress());
			}
		}
	}

	public DefaultComboBoxModel loadDeviceListMode() {
		DefaultComboBoxModel deviceListMode = new DefaultComboBoxModel();
		List<BleClient> clients = BleSlaveManager.getClients();
		for (BleClient c : clients) {
			// HashMap<String, String> devInfo = new HashMap<String, String>();
			// devInfo.put(DEVICE_NAME, c.getDevName());
			// devInfo.put(DEVICE_ADDRESS, c.getAddress());

			deviceListMode.addElement(c.getDevName());

		}

		return deviceListMode;
	}

	private boolean addSeries(String address) {
		if (address == null || mSeriesList == null)
			return false;

		MSG_DEBUG("addSeries, address: " + address);

		Color color = getColorForSeries();

		// XYSeries
		String seriesTitle;

		if (isClientAddress(address)) {
			BleClient client = BleSlaveManager.getClient(address);

			if (client != null) {
				// BluetoothDevice device = BluetoothAdapter.getDefaultAdapter()
				// .getRemoteDevice(client.getAddress());
				//
				// seriesTitle = PreferenceControl.getDeviceName(this, device);
				// cc.getTitleName(this, device, client);
				seriesTitle = address;
				// MSG_DEBUG("addSeries, Client: " + seriesTitle);
			} else {
				seriesTitle = address;

				// MSG_DEBUG("addSeries, Client: " + seriesTitle);
			}
		} else {
			int pos = address.lastIndexOf("/");

			seriesTitle = address.substring(pos + 1);

			MSG_DEBUG("addSeries, Local File: " + seriesTitle + ", Path: "
					+ address);
		}
		XYSeries series = jchart.createXYSeries(seriesTitle);
		// mDataset.addSeries(series);

		// SeriesRenderer
		// XYSeriesRenderer renderer = new XYSeriesRenderer();
		// renderer.setPointStyle(PointStyle.CIRCLE);
		// renderer.setFillPoints(true);
		// renderer.setColor(color);
		// renderer.setFillBelowLine(cc.getFillMode(this));
		// renderer.setFillBelowLineColor(color);
		// renderer.setLineWidth(5f);
		// mRenderer.addSeriesRenderer(renderer);

		// Data List
		// List<HashMap<String, Object>> datalist = new
		// ArrayList<HashMap<String, Object>>();

		// Adapter
		// SimpleAdapter adapter = createSimpleAdapter(datalist);
		DefaultListModel listModel = new DefaultListModel();

		// Add Series
		HashMap<String, Object> entry = new HashMap<String, Object>();

		entry.put("address", address);
		entry.put("series", series);
		// entry.put("renderer", renderer);
		entry.put("color", color);
		// entry.put("data_list", datalist);
		// entry.put("adapter", adapter);
		entry.put("list_model", listModel);

		mSeriesList.add(entry);

		// Add Tab
		// TabHost.TabSpec spec = mTabHost.newTabSpec(address);
		// spec.setIndicator(seriesTitle);
		// spec.setContent(this);
		// mTabHost.addTab(spec);

		// Update mTabHost
		// cc.updateTab(this, mTabHost, null);

		// Add Data
		new AddDataThread(this, address).start();

		return true;
	}

	public boolean removeSeries(String address) {
		if (address == null || mSeriesList == null)
			return false;

		MSG_DEBUG("removeSeries, address: " + address);

		for (int i = 0; i < mSeriesList.size(); i++) {
			HashMap<String, Object> entry = mSeriesList.get(i);

			String addr = (String) entry.get("address");

			if (addr.equals(address)) {
				// XYSeries
				XYSeries series = (XYSeries) entry.get("series");
				jchart.removeSeries(series);

				// SeriesRenderer
				// XYSeriesRenderer renderer = (XYSeriesRenderer) entry
				// .get("renderer");
				// mRenderer.removeSeriesRenderer(renderer);

				// Data List
				// List<HashMap<String, Object>> datalist =
				// (List<HashMap<String, Object>>) entry
				// .get("data_list");
				DefaultListModel datalist = (DefaultListModel) entry
						.get("list_model");
				datalist.clear();

				// runOnUiThread(new Runnable() {
				// public void run() {
				// // entry.remove("adapter");
				// SimpleAdapter adapter = createSimpleAdapter(datalist);//
				// "adapter"
				// // entry.put("adapter", adapter);
				// currentListView.setAdapter(adapter);
				// adapter.notifyDataSetChanged();
				// }
				// });
				repaintChartPanel();

				mSeriesList.remove(i);

				break;
			}
		}

		// Tab
		// mTabHost.clearAllTabs();

		// for (int i = 0; i < mSeriesList.size(); i++) {
		// HashMap<String, Object> entry = mSeriesList.get(i);
		//
		// String addr = (String) entry.get("address");
		// XYSeries series = (XYSeries) entry.get("series");

		// TabHost.TabSpec spec = mTabHost.newTabSpec(addr);
		// spec.setIndicator(series.getTitle());
		// spec.setContent(this);
		// if (mTabHost == null)
		// MSG_ERROR("mTabHost null");
		// // if (spec == null)
		// // MSG_ERROR("spec null");
		// mTabHost.addTab(spec);
		// cc.updateTab(this, mTabHost, null);
		// }

		return true;
	}

	public DefaultListModel getDataModel(String clientAddress) {
		if (clientAddress == null || mSeriesList == null)
			return null;

		for (int i = 0; i < mSeriesList.size(); i++) {
			HashMap<String, Object> entry = mSeriesList.get(i);

			String address = (String) entry.get("address");

			if (address.equals(clientAddress)) {
				DefaultListModel datalist = (DefaultListModel) entry
						.get("list_model");

				return datalist;
			}
		}

		MSG_ERROR("getDataList, Not Found, client: " + clientAddress);

		return null;
	}

	public XYSeries getXYSeries(String clientAddress) {
		if (clientAddress == null || mSeriesList == null)
			return null;

		for (int i = 0; i < mSeriesList.size(); i++) {
			HashMap<String, Object> entry = mSeriesList.get(i);

			String address = (String) entry.get("address");

			if (address.equals(clientAddress)) {
				XYSeries series = (XYSeries) entry.get("series");

				return series;
			}
		}

		MSG_ERROR("getSeries, Not Found, client: " + clientAddress);

		return null;
	}

	private Color getColorForSeries() {
		if (mSeriesList == null)
			return defaultColor;

		for (int i = 0; i < COLOR_MATRIX.length; i++) {
			int j = 0;

			for (j = 0; j < mSeriesList.size(); j++) {
				HashMap<String, Object> entry = mSeriesList.get(j);

				Color color = (Color) entry.get("color");

				if (color == COLOR_MATRIX[i])
					break;
			}

			if (j == mSeriesList.size())
				return COLOR_MATRIX[i];
		}

		return defaultColor;
	}

	// public List<HashMap<String, Object>> getDataList(String clientAddress) {
	// if (clientAddress == null || mSeriesList == null)
	// return null;
	//
	// for (int i = 0; i < mSeriesList.size(); i++) {
	// HashMap<String, Object> entry = mSeriesList.get(i);
	//
	// String address = (String) entry.get("address");
	//
	// if (address.equals(clientAddress)) {
	// List<HashMap<String, Object>> datalist = (List<HashMap<String, Object>>)
	// entry
	// .get("data_list");
	//
	// return datalist;
	// }
	// }
	//
	// MSG_ERROR("getDataList, Not Found, client: " + clientAddress);
	//
	// return null;
	// }

	public boolean isClientAddress(String address) {
		if (address == null)
			return false;

		if (address.endsWith(".csv"))
			return false;

		return true;
	}

	public String getFormateData(MultimeterReceivedData data) {
		String gap = "\t       ";
		String value = data.Index + gap + data.Func + gap + data.ValueString
				+ "  "+ data.Unit + gap + data.Time;
		return value;
	}

	public boolean saveReceiveData(BleClient c) {
		if (c != null) {
			c.saveReceivedData();
			c.clearReceivedData();
			return true;
		}
		return false;

	}

	public boolean clearClient(BleClient c) {
		if (c != null) {
			String address = c.getAddress();
			XYSeries series = getXYSeries(address);
			if (series != null) {
				series.clear();
			}
			DefaultListModel datalist = getDataModel(address);
			if (datalist != null) {
				datalist.clear();
			}

			c.clearReceivedData();
			return true;
		}
		return false;

	}

	public void setLegendTitle(XYSeries series, String s) {
		String devName = series.getDescription();
		series.setKey(devName + "(" + s + ")");
	}

	private void MSG_ERROR(String msg) {
		System.err.println("[ " + TAG + " ] :: Error :: " + msg);
	}

	private void MSG_DEBUG(String msg) {
		System.out.println("dbg[ " + TAG + " ] $$$:: " + msg);
	}

}
