package control;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import model.MultimeterReceivedData;

public class BroadcastAgent {

	private PropertyChangeSupport listernts = new PropertyChangeSupport(this);
	public static final String BROADCAST_DATA = "data.broadcast";
	public static final String BROADCAST_INTERACTION = "interaction.broadcast";
	public static final String BROADCAST_ENABLELINK = "enableLink.broadcast";
	public static final String BROADCAST_SCANDEVICEINFO = "scanDeviceInfo.broadcast";
	public static final String BROADCAST_OFFLINEDATASIZE = "offlineDataSize.broadcast";
	public static final String BROADCAST_OFFLINEPROGRESS = "offlineTransmitProgress.broadcast";
	public static final String BROADCAST_OFFLINETRANSMITEND = "offlineTransmitEnd.broadcast";

	public static final String STATUS_PORT_FOUND = "statusPortFound.broadcast";
	public static final String STATUS_PORT_UNFOUND = "statusPortUnFound.broadcast";
	public static final String STATUS_DEVICE_INIT_RESULT = "DeviceInitResult.broadcast";
	public static final String STATUS_Already_Performing_That_Task = "AlreadyPerformingTheTask.broadcast";

	public BroadcastAgent() {

	}

	public boolean addProperty(PropertyChangeListener listener) {
		if (listener == null)
			return false;
		listernts.addPropertyChangeListener(listener);
		return true;
	}

	public boolean removeProperty(PropertyChangeListener listener) {
		if (listener == null)
			return false;
		listernts.removePropertyChangeListener(listener);
		return true;
	}

	public void unRegisterListeners() {
		listernts = null;
	}

	public void sendBroadcast_PortFound(boolean isFound, Object newValue) {
		String mgsType = isFound ? STATUS_PORT_FOUND : STATUS_PORT_UNFOUND;
		if (listernts != null)
			listernts.firePropertyChange(mgsType, 0, newValue);
	}

	public void sendBroadcast_DeviceInitResult(Object oldValue, Object newValue) {
		if (listernts != null)
			listernts
					.firePropertyChange(STATUS_DEVICE_INIT_RESULT, 0, newValue);
	}
	public void sendBroadcast_AlreadyPerformingThatTask(Object oldValue, Object newValue) {
		if (listernts != null)
			listernts
			.firePropertyChange(STATUS_Already_Performing_That_Task, 0, newValue);
	}

	public void sendRealDataBroadcast(Object oldValue, Object newValue) {
		if (listernts != null) {
			listernts.firePropertyChange(BROADCAST_DATA, oldValue, newValue);
		}
	}

	public void sendActionBroadcast(Object oldValue, Object newValue) {
		if (listernts != null)
			listernts.firePropertyChange(BROADCAST_INTERACTION, oldValue,
					newValue);
	}

	public void sendEnableLinkBroadcast(Object oldValue, Object newValue) {
		if (listernts != null)
			listernts.firePropertyChange(BROADCAST_ENABLELINK, oldValue,
					newValue);
	}

	public void sendScanDeviceInfoBroadcast(Object oldValue, Object newValue) {
		if (listernts != null)
			listernts.firePropertyChange(BROADCAST_SCANDEVICEINFO, oldValue,
					newValue);
	}

	public void sendBroadcast_OfflineDataSize(Object oldValue, Object newValue) {
		if (listernts != null)
			listernts.firePropertyChange(BROADCAST_OFFLINEDATASIZE, oldValue,
					newValue);
	}

	public void sendBroadcast_OfflineTransmitProgress(Object oldValue,
			Object newValue) {
		if (listernts != null)
			listernts.firePropertyChange(BROADCAST_OFFLINEPROGRESS, oldValue,
					newValue);
	}

	public void sendBroadcast_OfflineTransmitEnd(Object oldValue,
			Object newValue) {
		if (listernts != null)
			listernts.firePropertyChange(BROADCAST_OFFLINETRANSMITEND,
					oldValue, newValue);
	}

}
