package control;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;

import javax.swing.DefaultListModel;

import org.jfree.data.xy.XYSeries;

import kernal.BleClient;
import model.BleSlaveManager;
import model.MultimeterReceivedData;

class AddDataThread extends Thread {
	/**
	 * 
	 */
	private final ChartControl chartCtr;
	private String mAddress;

	public AddDataThread(ChartControl cc, String address) {
		chartCtr = cc;
		MSG_INFO("Create AddDataThread, Address: " + address);

		mAddress = address;
	}

	public void run() {
		MSG_INFO("run, Begin add data, address: " + mAddress);

		setName("AddDataThread - " + mAddress);

		XYSeries series = chartCtr.getXYSeries(mAddress);

		// final List<HashMap<String, Object>> datalist = chartCtr
		// .getDataList(mAddress);
		final DefaultListModel datalist = chartCtr.getDataModel(mAddress);
		// SimpleAdapter adapter = chartActivity.getSimpleAdapter(mAddress);

		if (datalist == null) {// || series == null ||adapter == null
			MSG_ERROR("run, series/datalist/adapter not found");
			return;
		}

		if (chartCtr.isClientAddress(mAddress)) {
			BleClient client = BleSlaveManager.getClient(mAddress);

			if (client != null) {
				List<MultimeterReceivedData> receivedDataList = client
						.getReceivedData();

				for (int i = 0, len = receivedDataList.size(); i < len; i++) {
					MultimeterReceivedData data = receivedDataList.get(i);

					series.add(data.Index, data.Value);// for wave paint

					// final HashMap<String, Object> item = new HashMap<String,
					// Object>();
					// item.put("index", (new Integer(data.Index)).toString());
					// item.put("function", data.Func);
					// item.put("value", data.ValueString);
					// item.put("unit", data.Unit);
					// item.put("time", data.Time);
					// item.put("date", data.Date);

					datalist.addElement(chartCtr.getFormateData(data));
					// chartActivity.runOnUiThread(new Runnable() {
					// public void run() {
					// datalist.add(item);
					// }
					// });
				}
			}
		} else {
			openLocalFile2(mAddress, datalist);// series,
		}

		// chartActivity.mHandler.obtainMessage(
		// MultimeterChartActivity.MESSAGE_ADD_DATA_COMPLETE, 0, 0,
		// mAddress).sendToTarget();

		return;
	}

	void openLocalFile2(String filePath, final DefaultListModel datalist) {// ,
																			// XYSeries
																			// series
		if (!filePath.endsWith(".csv"))
			return;
		/**
		 * 使用缓冲区 可以使用缓冲区对象的 read() 和 readLine()方法。
		 */
		// InputStream in = new FileInputStream(filePath);// 字节流
		// InputStreamReader isr = new InputStreamReader(in);// 字符流
		// BufferedReader bufr = new BufferedReader(isr);// 缓冲
		BufferedReader bufr;
		try {
			bufr = new BufferedReader(new InputStreamReader(
					new FileInputStream(filePath), "utf-16"));
			String line = null;
			while ((line = bufr.readLine()) != null) {

				if (!parseLineData(line, datalist)) {// , series
					continue;
				}

			}
			bufr.close();

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	private boolean parseLineData(String line, final DefaultListModel datalist) {// ,
																					// XYSeries
																					// series
		String[] columns = line.split(",");

		String IndexString, FuncString, ValueString, UnitString, TimeString = "", DateString = "";

		int Index;
		IndexString = columns[0];

		double Value;
		if (columns.length == 6) {
			FuncString = columns[1];
			ValueString = columns[2];
			UnitString = columns[3];
			TimeString = columns[4];
			DateString = columns[5];
		} else if (columns.length == 5) {
			FuncString = columns[1];
			ValueString = columns[2];
			UnitString = columns[3];
			TimeString = columns[4];
		} else if (columns.length == 4) {
			FuncString = columns[1];
			ValueString = columns[2];
			UnitString = columns[3];
		} else if (columns.length == 3) {
			FuncString = "";
			ValueString = columns[1];
			UnitString = columns[2];
		} else {
			MSG_ERROR("Unexpected line, column: " + columns.length + ", line: "
					+ line);
			return false;
		}

		Index = Integer.parseInt(IndexString);
		try {
			Value = Double.parseDouble(ValueString);
		} catch (Exception e) {
			Value = 0;
			// e.printStackTrace();
		}

		// series.add(Index, Value);

		// final HashMap<String, Object> item = new HashMap<String, Object>();
		// item.put("index", IndexString);
		// item.put("function", FuncString);
		// item.put("value", ValueString);
		// item.put("unit", UnitString);
		// item.put("time", TimeString);
		// item.put("date", DateString);

		// chartActivity.runOnUiThread(new Runnable() {
		// public void run() {
		MultimeterReceivedData data = new MultimeterReceivedData();
		data.Index = Index;
		data.Func = FuncString;
		data.ValueString = ValueString;
		data.Unit = UnitString;
		data.Time = TimeString;
		data.Date = DateString;
		datalist.addElement(chartCtr.getFormateData(data));
		// }
		// });
		return true;
	}

	/** Debug */
	private String TAG = "AddDataThread";
	// private static final boolean DEBUG = false;
	private static final boolean INFO = true;

	// private void MSG_DEBUG(String msg) {
	// if (DEBUG)
	// Log.d(TAG, "[ Multimeter ][ " + TAG + " ] :: " + msg);
	// }
	//
	private void MSG_ERROR(String msg) {
		System.err.println("[ Multimeter ][ " + TAG + " ] :: Error :: " + msg);
	}

	private void MSG_INFO(String msg) {
		if (INFO)
			System.out.println("[ " + TAG + " ] $$$:: " + msg);
	}
}