package checkBLEFunc;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import kernal.BleClient;
import model.BleSlaveManager;

//import javax.comm.*;

public class TransmitBleDialog extends JDialog {

	public interface PP {
		public void updateInput(String s);

		public void updateOutput(String s);
	}

	class PI implements PP {
		@Override
		public void updateInput(String s) {
		}

		@Override
		public void updateOutput(String s) {
		}

	}

	// private Enumeration portList;/* Enumeration 为枚举型类,在util中 */

	private static TransmitBleDialog dlg;

	public static TransmitBleDialog getInstance(JFrame main) {
		if (dlg == null)
			dlg = new TransmitBleDialog(main);
		return dlg;
	}

	/* 安排窗体 */
	private TransmitBleDialog(JFrame main) {
		super(main);
		setTitle("PC BLE IO");
		setSize(new Dimension(500, 136));
		setVisible(true);
		add(initNorthPane(), "North");
		add(initCenterPane(), "Center");
		add(initSouthPane(), "South");

		setLocationRelativeTo(null);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		setResizable(false);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {

				if (t1 != null) {
					t1.onClose = true;
					t1.serialPort.close();
				}
				if (t2 != null) {
					t2.onClose = true;
					t2.serialPort.close();
				}
				if (t3 != null) {
					t3.onClose = true;
					t3.serialPort.close();
				}
				dispose();
				dlg = null;
				System.out.println("TransmitBleDialogClosing");
			}

			@Override
			public void windowClosed(WindowEvent e) {

				// if (t1 != null)
				// t1.serialPort.close();
				// if (t2 != null)
				// t2.serialPort.close();
				// if (t3 != null)
				// t3.serialPort.close();
				// System.out.println("TransmitBleDialogClosed");
				// dispose();
				// dlg = null;
				// super.windowClosed(e);
			}
		});

		JLabel[] addrs = new JLabel[] { addr1, addr2, addr3 };
		ArrayList<BleClient> slaves = BleSlaveManager.getClients();
		for (int i = 0; i < slaves.size(); i++) {
			if (i > 2)
				break;
			addrs[i].setText(slaves.get(i).getAddress());

		}

	}

	JLabel addr1, addr2, addr3;
	JLabel msg1, msg2, msg3;
	TransmitBleCmdHandler t1, t2, t3;

	private JPanel initNorthPane() {
		JPanel p = new JPanel();
		p.setLayout(new FlowLayout(FlowLayout.LEADING));
		addr1 = new JLabel("Disconnected");
		addr1.setPreferredSize(labd);
		p.add(addr1);

		JButton open1 = new JButton("open1");
		p.add(open1);

		JButton close1 = new JButton("close1");
		p.add(close1);

		msg1 = new JLabel();
		p.add(msg1);

		open1.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				open1.setEnabled(false);
				String dest = addr1.getText();
				if (!dest.equals("Disconnected")) {
					t1 = new TransmitBleCmdHandler(dest, new PI() {
						@Override
						public void updateInput(String s) {
							msg1.setText(s);
						}

						@Override
						public void updateOutput(String s) {
							msg1.setText(s);
						}

					});
					t1.onClose = false;
					t1.startTransmit("COM101");
					open1.setText("COM101");
				}

			}
		});
		close1.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				open1.setEnabled(true);
				if (t1 != null) {
					t1.onClose = true; // 用于中止线程的run()方法
					t1.serialPort.close(); // 关闭串口
					open1.setText("open1");
					// in_message.setText(serialPort + "串口关闭,停止发送数据.");
				}
			}
		});

		return p;
	}

	private JPanel initCenterPane() {
		JPanel p = new JPanel();
		p.setLayout(new FlowLayout(FlowLayout.LEADING));
		addr2 = new JLabel("Disconnected");
		addr2.setPreferredSize(labd);
		p.add(addr2);

		JButton open2 = new JButton("open2");
		p.add(open2);

		JButton close2 = new JButton("close2");
		p.add(close2);

		msg2 = new JLabel();
		p.add(msg2);

		open2.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				open2.setEnabled(false);
				String dest = addr2.getText();
				if (!dest.equals("Disconnected")) {
					t2 = new TransmitBleCmdHandler(dest, new PI() {
						@Override
						public void updateInput(String s) {
							msg2.setText(s);
						}

						@Override
						public void updateOutput(String s) {
							msg2.setText(s);
						}

					});
					t2.onClose = false;
					t2.startTransmit("COM103");
					open2.setText("COM103");
				}

			}
		});
		close2.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				open2.setEnabled(true);
				if (t2 != null) {
					t2.onClose = true; // 用于中止线程的run()方法
					t2.serialPort.close(); // 关闭串口
					open2.setText("open2");
					// in_message.setText(serialPort + "串口关闭,停止发送数据.");
				}
			}
		});

		return p;
	}

	Dimension labd = new Dimension(110, 25);

	private JPanel initSouthPane() {
		JPanel p = new JPanel();
		p.setLayout(new FlowLayout(FlowLayout.LEADING));
		addr3 = new JLabel("Disconnected");
		addr3.setPreferredSize(labd);
		p.add(addr3);

		JButton open3 = new JButton("open3");
		p.add(open3);

		JButton close3 = new JButton("close3");
		p.add(close3);

		msg3 = new JLabel();
		p.add(msg3);

		open3.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				open3.setEnabled(false);
				String dest = addr3.getText();
				if (!dest.equals("Disconnected")) {
					t3 = new TransmitBleCmdHandler(dest, new PI() {
						@Override
						public void updateInput(String s) {
							msg3.setText(s);
						}

						@Override
						public void updateOutput(String s) {
							msg3.setText(s);
						}

					});
					t3.onClose = false;
					t3.startTransmit("COM105");
					open3.setText("COM105");
				}

			}
		});
		close3.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				open3.setEnabled(true);
				if (t3 != null) {
					t3.onClose = true; // 用于中止线程的run()方法
					t3.serialPort.close(); // 关闭串口
					open3.setText("open3");
					// in_message.setText(serialPort + "串口关闭,停止发送数据.");
				}
			}
		});
		return p;
	}

	public static void main(String args[]) {
		TransmitBleDialog f = new TransmitBleDialog(null);
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		f.pack();
	}

}
