package checkBLEFunc;

/****************************************** * 程序文件名称：SendComm.java * 功能：从串行口COM1中发送数据  ******************************************/
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import kernal.BleClient;
import model.BleSlaveManager;
import model.MultimeterReceivedData;
import storeroom.util.ByteUtil;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.util.List;

import javax.swing.JDialog;
import javax.swing.JFrame;

import control.MainControl;
import frame.AboutDlg;

//import javax.comm.*;

public class CheckBleFrame extends JDialog implements Runnable, ActionListener {

	private static CommPortIdentifier portId;/* 检测系统中可用的通讯端口类 */
	// private Enumeration portList;/* Enumeration 为枚举型类,在util中 */
	private OutputStream outputStream;/* RS-232的串行口.输出流 */
	private InputStream inputStream;/* RS-232的串行口 .输入流 */
	private SerialPort serialPort;
	private Thread readThread;

	Panel btnPane = new Panel();
	TextField in_message = new TextField("");// 打开COM1,波特率9600,数据位8,停止位1
	TextArea out_message = new TextArea();
	Button btnOpen = new Button("Open Comm101");// 打开串口, 发送数据
	Button btnClose = new Button("Close Comm");// 关闭串口, 停止发送数据
	private byte data[] = new byte[1024];// { (byte)2, (byte)1 };//
	/* 设置判断是否要关闭串口的标志 */
	boolean onClose = false;

	private static CheckBleFrame frame;

	public static CheckBleFrame getInstance() {
		if (frame == null)
			frame = new CheckBleFrame();
		return frame;
	}

	/* 安排窗体 */
	private CheckBleFrame() {
		setTitle("蓝牙表PC控制接口");
		setSize(new Dimension(500, 250));
		setVisible(true);
		add(out_message, "Center");
		add(btnPane, "North");
		add(in_message, "South");

		btnPane.add(btnOpen);
		btnPane.add(btnClose);

		btnOpen.addActionListener(this);
		btnClose.addActionListener(this);

		setLocationRelativeTo(null);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				dispose();
			}
		});
	}

	public void actionPerformed(ActionEvent event) {
		if (event.getSource() == btnClose) {
			btnOpen.setEnabled(true);
			onClose = true; // 用于中止线程的run()方法
			in_message.setText(serialPort + "串口关闭,停止发送数据.");
			serialPort.close(); // 关闭串口

		} else {
			btnOpen.setEnabled(false);
			onClose = false;
			// /* 从文本区按字节读取数据 */
			// data = out_message.getText().getBytes();
			/* 打开串口 */
			start();
		}
	}

	/* 打开串口,并调用线程发送数据 */
	public void start() {
		/* 获取系统中所有的通讯端口 */
		Enumeration portList = CommPortIdentifier.getPortIdentifiers();
		// TODO 做成下拉框显示出来，等待用户选择一个选项。

		/* 用循环结构找出串口 */
		// TODO 把用户选中选项当索引，在循环结构中找出串口。

		while (portList.hasMoreElements()) { /* 强制转换为通讯端口类型 */
			portId = (CommPortIdentifier) portList.nextElement();
			if (portId.getPortType() == CommPortIdentifier.PORT_SERIAL) {

				if (portId.getName().equals("COM101")) {
					/* 打开串口 */
					try {
						serialPort = (SerialPort) portId.open("MyComm101", 2000);
					} catch (PortInUseException e) {
						System.err.println("MyComm101 portId.open PortInUseException ");
					}
					/* 设置串口输出流 */
					try {
						outputStream = serialPort.getOutputStream();
						inputStream = serialPort.getInputStream();
					} catch (IOException e) {
						System.err.println("getOutputStream outputStream ");
					}
					break;
				} else
					System.out.println(portId.getName());
			}
		}
		// TODO 若找不到串口，停止执行
		if (serialPort == null) {
			in_message.setText("无法找到合适端口");
			return;
		}
		in_message.setText(serialPort.getName() + "串口已经打开,");

		/* 设置串口通讯参数 */
		try {
			serialPort.setSerialPortParams(9600, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
		} catch (UnsupportedCommOperationException e) {
			System.err.println("Set UnsupportedCommOperationException ");
		}

		/* 调用线程发送数据 */
		try {
			readThread = new Thread(this); // 线程负责每发送一次数据，休眠2秒钟
			readThread.start();
		} catch (Exception e) {
		}
	}

	@Override
	public void run() {

		while (!onClose) {
			/*  */
			try {
				BleClient mClient = BleSlaveManager.getSelectedClient();
				if (mClient != null && mClient.isConnected()) {

					byte[] buf = ByteUtil.readInputStreamToBuf(inputStream);
					String center_cmd = new String(buf);
					int size = buf.length;
					
					if (size > 0 && center_cmd.equalsIgnoreCase("meas?")) {
						// return realtime multimeter value

						List<MultimeterReceivedData> list = mClient.getReceivedData();
						MultimeterReceivedData rd = list.get(list.size() - 1);

						outputStream.write(rd.ValueString.getBytes());
						outputStream.flush();
						out_message.setText(rd.ValueString);
						System.out.println(rd.ValueString);
						
					} else if (size > 0 &&!center_cmd.contains("?")) {
						// send cmd to low multimeter
						byte funId=-1;
						switch (center_cmd) {
						case "select":
							funId=MainControl.selectPress;
							break;
						case "range":
							funId=MainControl.rangePress;
							break;
						case "hold":
							funId=MainControl.holdPress;
							break;
						case "rel":
							funId=MainControl.relPress;
							break;
						case "hz":
							funId=MainControl.hzPress;
							break;
						case "max":
							funId=MainControl.maxPress;
							break;
						}
						System.err.println("funId:" + funId);
						MainControl.cWriteCmd(mClient, funId, false);

						in_message.setText(serialPort + ":" + center_cmd + " send");
						System.out.println(serialPort + ":" + center_cmd + " send");
					} else {
						in_message.setText(serialPort + ":" + center_cmd + " ,can`t recognize");
//						System.out.println(serialPort + ":" + center_cmd + " ,can`t recognize");
					}
				}else{
					in_message.setText(serialPort.getName() + "没有蓝牙表连接,");
				}

			} catch (IOException e) {
				e.printStackTrace();
				System.err.println("write(data) IOException ");
			}
			/* 发送数据后休眠1秒钟,然后再重发 */
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}

	}

	public static void main(String args[]) {
		CheckBleFrame f = new CheckBleFrame();
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		f.pack();
	}

}
