/*
 * Decompiled with CFR 0.152.
 */
package model.chartModel;

import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;
import storeroom.draw.Draw;

public class CreateJChartLine
implements ActionListener {
    ChartPanel chart;
    XYSeriesCollection dataset;
    final String xTitle = "Index";
    final String yTitle = "value";
    JFreeChart freeChart;

    public CreateJChartLine() {
        XYSeriesCollection dataset = this.getDataset();
        this.freeChart = this.createChart(dataset);
        this.chart = new ChartPanel(this.freeChart);
        this.chart.setOpaque(false);
    }

    public ChartPanel getChartPanel() {
        return this.chart;
    }

    public JFreeChart createChart(XYSeriesCollection categoryDataset) {
        JFreeChart jfreechart = ChartFactory.createXYLineChart(null, (String)"Index", (String)"value", (XYDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        jfreechart.setAntiAlias(false);
        jfreechart.setBackgroundPaint((Paint)Draw.PlatBg);
        XYPlot plot = jfreechart.getXYPlot();
        plot.setBackgroundAlpha(0.8f);
        plot.setForegroundAlpha(0.8f);
        Font font = new Font("\u7039\u5b29\u7d8b", 0, 12);
        LegendTitle lg = jfreechart.getLegend();
        lg.setPosition(RectangleEdge.TOP);
        lg.setItemFont(font);
        ValueAxis x_axis = plot.getDomainAxis();
        x_axis.setAutoTickUnitSelection(true);
        plot.getRangeAxis();
        return jfreechart;
    }

    public XYSeriesCollection getDataset() {
        if (this.dataset == null) {
            this.dataset = new XYSeriesCollection();
        }
        return this.dataset;
    }

    public XYSeries createXYSeries(String seriesTitle) {
        XYSeries series = new XYSeries((Comparable)((Object)seriesTitle));
        series.setDescription(seriesTitle);
        this.dataset.addSeries(series);
        return series;
    }

    public void removeSeries(XYSeries series) {
        this.dataset.removeSeries(series);
    }

    public void setXTitle(String s) {
        ValueAxis axis = this.freeChart.getXYPlot().getDomainAxis();
        axis.setLabel("Index(" + s + ")");
    }

    public void setYTitle(String s) {
        ValueAxis axis = this.freeChart.getXYPlot().getRangeAxis();
        axis.setLabel("value(" + s + ")");
    }

    public String getYTitle() {
        return this.freeChart.getXYPlot().getRangeAxis().getLabel();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }
}

