/*
 * Decompiled with CFR 0.152.
 */
package kernal;

import model.BleSeriesInfo;
import model.SeriesBT;
import model.SeriesOW;

public class Command {
    public static final int GATT_WriteLongCharValue = 64918;
    public static final int GATT_ReadCharValue = 64906;
    public static final int GATT_WriteCharValue = 64914;
    public static final byte F1FF = 37;
    public static final byte F2FF = 40;
    public static final byte F3FF = 43;
    public static final byte F4FF = 46;
    public static final byte[] F1_RW_UUID = new byte[]{-15, -1};
    public static final byte[] F2_R_UUID = new byte[]{-14, -1};
    public static final byte[] F3_W_UUID = new byte[]{-13, -1};
    public static boolean sDebug = true;

    public static byte[] GATT_WriteCharValue_handle(byte[] connHandle, byte[] rwHandle, byte[] value) {
        byte commandType = 1;
        byte opCodeLow = -110;
        byte opCodeHigh = -3;
        byte dataLength = (byte)(4 + value.length);
        byte connHandleLow = connHandle[0];
        byte connHandleHigh = connHandle[1];
        byte handleLow = rwHandle[0];
        byte handleHigh = rwHandle[1];
        byte[] temp = new byte[]{commandType, opCodeLow, opCodeHigh, dataLength, connHandleLow, connHandleHigh, handleLow, handleHigh};
        byte[] cmds = new byte[temp.length + value.length];
        System.arraycopy(temp, 0, cmds, 0, temp.length);
        System.arraycopy(value, 0, cmds, temp.length, value.length);
        return cmds;
    }

    public static byte[] GATT_WriteLongCharValue_handle(byte[] connHandle, byte[] rwHandle, byte[] value) {
        byte commandType = 1;
        int opCodeLow = -106;
        int opCodeHigh = -3;
        byte dataLength = (byte)(6 + value.length);
        byte connHandleLow = connHandle[0];
        byte connHandleHigh = connHandle[1];
        byte handleLow = rwHandle[0];
        byte handleHigh = rwHandle[1];
        byte[] byArray = new byte[10];
        byArray[0] = commandType;
        byArray[1] = opCodeLow;
        byArray[2] = opCodeHigh;
        byArray[3] = dataLength;
        byArray[4] = connHandleLow;
        byArray[5] = connHandleHigh;
        byArray[6] = handleLow;
        byArray[7] = handleHigh;
        byte[] temp = byArray;
        byte[] cmds = new byte[temp.length + value.length];
        System.arraycopy(temp, 0, cmds, 0, temp.length);
        System.arraycopy(value, 0, cmds, temp.length, value.length);
        return cmds;
    }

    public static byte[] GATT_ReadCharValue_handle(byte[] connHandle, byte handle) {
        byte commandType = 1;
        byte opCodeLow = -118;
        byte opCodeHigh = -3;
        byte dataLength = 4;
        byte connHandleLow = connHandle[0];
        byte connHandleHigh = connHandle[1];
        byte handleLow = handle;
        byte handleHigh = 0;
        byte[] cmds = new byte[]{commandType, opCodeLow, opCodeHigh, dataLength, connHandleLow, connHandleHigh, handleLow, handleHigh};
        return cmds;
    }

    public static byte[] GATT_ReadCharValue_byUUID(byte[] connHandle, byte[] uuid) {
        byte commandType = 1;
        byte opCodeLow = -76;
        byte opCodeHigh = -3;
        byte dataLength = 8;
        byte connHandleLow = connHandle[0];
        byte connHandleHigh = connHandle[1];
        byte startHandleLow = 1;
        byte startHandleHigh = 0;
        byte endHandleLow = -1;
        byte endHandleHigh = -1;
        byte typeLow = uuid[0];
        byte typeHigh = uuid[1];
        byte[] cmds = new byte[]{commandType, opCodeLow, opCodeHigh, dataLength, connHandleLow, connHandleHigh, startHandleLow, startHandleHigh, endHandleLow, endHandleHigh, typeLow, typeHigh};
        return cmds;
    }

    public static byte[] initcmd() {
        byte[] byArray = new byte[42];
        byArray[0] = 1;
        byArray[2] = -2;
        byArray[3] = 38;
        byArray[4] = 8;
        byArray[5] = 5;
        byArray[38] = 1;
        byte[] arr = byArray;
        return arr;
    }

    public static byte[] discoveryRequest() {
        byte[] byArray = new byte[7];
        byArray[0] = 1;
        byArray[1] = 4;
        byArray[2] = -2;
        byArray[3] = 3;
        byArray[4] = DiscoveryMode.General.value;
        byArray[5] = 1;
        byte[] arr = byArray;
        return arr;
    }

    public static byte[] linkRequest(byte[] slaveAddr) {
        byte[] byArray = new byte[7];
        byArray[0] = 1;
        byArray[1] = 9;
        byArray[2] = -2;
        byArray[3] = 9;
        byte[] arr = byArray;
        byte[] cmds = new byte[arr.length + 6];
        System.arraycopy(arr, 0, cmds, 0, arr.length);
        System.arraycopy(slaveAddr, 0, cmds, arr.length, 6);
        return cmds;
    }

    public static byte[] terminateLinkRequest(byte[] connHandle) {
        byte[] arr = new byte[]{1, 10, -2, 3, connHandle[0], connHandle[1], 19};
        return arr;
    }

    public static byte[] getHandle(BleSeriesInfo series, byte charIdx) {
        if (series.isOWSeries()) {
            return SeriesOW.getHandle(charIdx);
        }
        return SeriesBT.getHandle(charIdx);
    }

    public static void println(String s) {
        if (sDebug) {
            System.out.println(s);
        }
    }

    private static enum DiscoveryMode {
        Non_Connectable(0),
        General(1),
        Limited(2),
        All(3);

        public byte value;

        private DiscoveryMode(byte index) {
            this.value = index;
        }
    }
}

