/*
 * Decompiled with CFR 0.152.
 */
package kernal;

import kernal.Command;
import kernal.HexCmds;
import main.Platform;
import model.BleClientGattCallback;
import model.BleSeriesInfo;
import model.ConnHandleResult;
import model.MultimeterClient;
import model.onRunable.OnReadRunnable;
import model.onRunable.OnWriteRunnable;
import storeroom.util.EndianUtil;

public class BleClient
extends MultimeterClient {
    private BleClientGattCallback bleCallback;
    private ConnHandleResult conn;
    private boolean connectStatus;
    private byte READ_HANDLE = 0;
    private byte WRITE_HANDLE = 0;
    private OnWriteRunnable onWriteRunable = null;
    private OnReadRunnable onReadRunable = null;
    private BleSeriesInfo seriesInfo;

    public BleClient(String address, BleClientGattCallback bleCallback) {
        super(address);
        this.bleCallback = bleCallback;
        this.conn = new ConnHandleResult();
        this.seriesInfo = new BleSeriesInfo();
    }

    public void setConnHandle(ConnHandleResult tmpResult) {
        this.conn = tmpResult;
        this.connectStatus = true;
    }

    public ConnHandleResult getConnHandle() {
        return this.conn;
    }

    public int getConnID() {
        return this.conn.ConnID;
    }

    public BleClientGattCallback getCallback() {
        return this.bleCallback;
    }

    public BleSeriesInfo getBleSeries() {
        return this.seriesInfo;
    }

    public void onConnectionStateChange(int newState) {
        if (this.bleCallback != null) {
            this.bleCallback.onConnectionStateChange(this.mAddress, newState);
        }
    }

    public void onCharacteristicRead(int status, byte[] value) {
        if (this.onReadRunable != null) {
            this.onReadRunable.acceptParameter(status, value);
            this.onReadRunable.run();
            this.onReadRunable = null;
        }
        if (this.bleCallback != null) {
            this.bleCallback.onCharacteristicRead(status, this.READ_HANDLE, value);
        }
    }

    public void onCharacteristicWrite(int status) {
        if (this.onWriteRunable != null) {
            this.onWriteRunable.acceptParameter(status);
            this.onWriteRunable.run();
            this.onWriteRunable = null;
        }
        if (this.bleCallback != null) {
            this.bleCallback.onCharacteristicWrite(status, this.WRITE_HANDLE);
        }
    }

    public void onCharacteristicChanged(ConnHandleResult tmpConnResult, int status, byte[] data) {
        this.parseReadData(this, data);
        if (this.bleCallback != null) {
            this.bleCallback.onCharacteristicChanged(tmpConnResult, status, data);
        }
    }

    public void writeCharacteristic(byte FxFF, byte[] value) {
        this.WRITE_HANDLE = FxFF;
        byte[] cmds = null;
        switch (FxFF) {
            case 37: {
                byte[] handle1 = Command.getHandle(this.seriesInfo, FxFF);
                cmds = Command.GATT_WriteLongCharValue_handle(this.conn.getConnArr(), handle1, value);
                break;
            }
            case 40: {
                break;
            }
            case 43: {
                byte[] handle2 = Command.getHandle(this.seriesInfo, FxFF);
                cmds = Command.GATT_WriteCharValue_handle(this.conn.getConnArr(), handle2, value);
                break;
            }
        }
        Platform.getBle().writeRequest(cmds);
    }

    public void readCharacteristic(byte handle) {
        this.READ_HANDLE = handle;
        byte[] cmds = null;
        switch (handle) {
            case 37: {
                cmds = Command.GATT_ReadCharValue_byUUID(this.conn.getConnArr(), Command.F1_RW_UUID);
                break;
            }
            case 40: {
                cmds = Command.GATT_ReadCharValue_byUUID(this.conn.getConnArr(), Command.F2_R_UUID);
                break;
            }
            case 43: {
                break;
            }
        }
        Platform.getBle().readRequest(cmds);
    }

    public void parseReadData(BleClient mClient, byte[] buf) {
        int len = buf.length;
        if (this.isOnFlashTransmit()) {
            if (this.seriesInfo.isOW55()) {
                this.handleReceivedData_flash55(mClient, buf, len);
                System.err.println("seriesInfo.isOW55");
            } else {
                this.handleReceivedData_flash2(mClient, buf, len);
            }
        } else {
            this.handleReceivedData_common(mClient, buf, len, this.seriesInfo.isOW55());
        }
    }

    public boolean isConnected() {
        return this.connectStatus;
    }

    public void disconnect() {
        this.connectStatus = false;
        this.bleCallback = null;
        Platform.getBle().terminateLinkRequest(this.conn.getConnArr());
    }

    public void writeCmd_GetOfflineDataSize() {
        byte[] value = new HexCmds().getReadLen();
        this.writeCharacteristic((byte)37, value);
        this.onWriteRunable = new OnWriteRunnable(){

            @Override
            public void run() {
                if (this.status == 2) {
                    BleClient.this.readCharacteristic((byte)37);
                    BleClient.this.onReadRunable = new OnReadRunnable(){

                        @Override
                        public void run() {
                            if (this.status == 2) {
                                byte[] arr = this.value;
                                int len = EndianUtil.ByteArrToIntL(arr);
                                System.out.println("rn:BleClient.writeCmdNGetOfflineDataSize.offDataLen: " + len);
                                Platform.getBle().broadcast.sendBroadcast_OfflineDataSize(null, len);
                            }
                        }
                    };
                }
            }
        };
    }

    public void readDeviceInfo() {
        this.readCharacteristic((byte)40);
        this.onReadRunable = new OnReadRunnable(){

            @Override
            public void run() {
                byte[] info = this.value;
                BleClient.this.MSG_INFO("read char2 info# len:" + info.length);
                BleClient.this.seriesInfo.init();
                if (info != null && info.length >= 1) {
                    byte seriesId = info[0];
                    BleClient.this.seriesInfo.setSeries(seriesId);
                    BleClient.this.bleCallback.onDeviceSeriesRead(seriesId);
                    BleClient.this.MSG_INFO("read info# series:" + seriesId);
                }
                BleClient.this.seriesInfo.authorizedSerie();
                if (info != null && info.length >= 2) {
                    byte powerLeft = info[1];
                    BleClient.this.seriesInfo.setBattaryPostSupportable(powerLeft);
                    BleClient.this.MSG_INFO("read info# powerLeft:" + powerLeft);
                }
                if (info != null && info.length >= 5) {
                    byte[] version = new byte[]{info[2], info[3], info[4]};
                    BleClient.this.seriesInfo.readFirmwareVersion(version);
                    BleClient.this.MSG_INFO("read info# firmVersion:" + BleClient.this.seriesInfo.getFirmwareVersionLabel());
                    BleClient.this.MSG_INFO("read info# offlineTime:" + BleClient.this.seriesInfo.isSurportOfflineDate());
                }
                if (info != null && info.length >= 6) {
                    switch (info[5]) {
                        case -1: {
                            BleClient.this.seriesInfo.setFlashRecordSupportable(false);
                            break;
                        }
                        case 0: {
                            BleClient.this.seriesInfo.setFlashRecordSupportable(true);
                            break;
                        }
                        case 1: {
                            BleClient.this.seriesInfo.setFlashRecordSupportable(true);
                            BleClient.this.seriesInfo.setOnFlashRecordStatus(true);
                        }
                    }
                    BleClient.this.MSG_INFO("read info# supportFlashRecord? " + BleClient.this.seriesInfo.isSupportFlashRecord());
                }
                if (!BleClient.this.seriesInfo.isCheckIdOnce()) {
                    BleClient.this.seriesInfo.setCheckIdOnce(true);
                }
            }
        };
    }

    public void writeCmd_ReadOfflineData() {
        HexCmds lib = new HexCmds();
        boolean support = this.getBleSeries().isSurportOfflineDate();
        byte[] cmds = support ? lib.getRead1Cmd() : lib.getReadCmd();
        this.writeCharacteristic((byte)37, cmds);
        this.onWriteRunable = new OnWriteRunnable(){

            @Override
            public void run() {
                if (this.status == 2) {
                    System.out.println("BleClient#writeCmd_ReadOfflineData success");
                    BleClient.this.setTransmitState(2);
                } else {
                    System.err.println("BleClient#writeCmd_ReadOfflineData failed");
                }
            }
        };
    }
}

