/*
 * Decompiled with CFR 0.152.
 */
package frame.view;

import control.MainControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.BleSlaveManager;
import model.MultimeterReceivedData;
import storeroom.draw.Draw;

public class MultiListItem
extends JPanel
implements PropertyChangeListener {
    private JLabel titlelbl;
    private JLabel valuelbl;
    private JLabel funclbl;
    private JLabel modelbl;
    private JLabel unitlbl;
    JPanel north;
    JPanel center;
    JPanel west;
    JPanel east;
    Dimension itemDim = new Dimension(1000, 170);
    Dimension leftDim = new Dimension(130, 130);
    Dimension rightDim = new Dimension(200, 130);
    Font titleFt_single = new Font("SansSerif", 0, 16);
    Font valueFt_single = new Font("SansSerif", 0, 168);
    Font funcFt_single = new Font("SansSerif", 0, 22);
    Font unitFt_single = new Font("SansSerif", 0, 38);
    Font titleFt_multi = new Font("SansSerif", 0, 16);
    Font valueFt_multi = new Font("SansSerif", 0, 88);
    Font funcFt_multi = new Font("SansSerif", 0, 16);
    Font unitFt_multi = new Font("SansSerif", 0, 28);
    private BleAgent ag;
    private MainControl mainCtr;
    public String addr;
    boolean onS;

    public MultiListItem(MainControl mainCtr, String addr) {
        this.mainCtr = mainCtr;
        this.addr = addr;
        this.init();
        this.switchMulti_SingleLayout(this.onS);
        this.ag = Platform.getBle();
        this.ag.broadcast.addProperty(this);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.createTitleView();
        this.createValueView();
        this.createFunc_ModeView();
        this.createUnitView();
        this.addBackgroundChangeListenner();
    }

    private void createTitleView() {
        this.north = new JPanel();
        this.add((Component)this.north, "North");
        this.north.setLayout(new FlowLayout(0));
        JButton blueToothBtn = Draw.createRolloverBtn(MultiListItem.class, "/storeroom/draw/listItem_bt", "/storeroom/draw/listItem_delete");
        this.north.add(blueToothBtn);
        this.titlelbl = new JLabel("BLE BDM2");
        this.titlelbl.setFont(this.titleFt_multi);
        this.titlelbl.setText(this.addr);
        this.north.add(this.titlelbl);
        blueToothBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BleClient mClient = BleSlaveManager.getClient(MultiListItem.this.addr);
                if (mClient != null) {
                    mClient.disconnect();
                    Platform.getMain().onPopupItem(MultiListItem.this.addr);
                    BleSlaveManager.onPopupClient(mClient);
                }
            }
        });
    }

    private void createValueView() {
        this.center = new JPanel();
        this.add((Component)this.center, "Center");
        this.valuelbl = new JLabel("347.6");
    }

    private void createFunc_ModeView() {
        this.west = new JPanel();
        this.west.setPreferredSize(this.leftDim);
        this.west.setLayout(new BorderLayout());
        this.add((Component)this.west, "West");
        JPanel westRP = new JPanel();
        this.west.add((Component)westRP, "East");
        westRP.setLayout(new BoxLayout(westRP, 1));
        westRP.setOpaque(false);
        JLabel gap1 = new JLabel(" ");
        westRP.add(gap1);
        this.funclbl = new JLabel("DCmV");
        westRP.add(this.funclbl);
        this.modelbl = new JLabel("AUTO");
        this.modelbl.setFont(this.funcFt_multi);
        westRP.add(this.modelbl);
    }

    private void createUnitView() {
        this.east = new JPanel();
        this.east.setPreferredSize(this.rightDim);
        this.east.setLayout(new BorderLayout());
        this.add((Component)this.east, "East");
        JPanel eastSP = new JPanel();
        eastSP.setOpaque(false);
        this.east.add((Component)eastSP, "South");
        this.unitlbl = new JLabel("mV");
        eastSP.add(this.unitlbl);
    }

    private void addBackgroundChangeListenner() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MultiListItem.this.mainCtr.setSelectItem(MultiListItem.this);
                        MultiListItem.this.mainCtr.updateCmdBtnsPane();
                    }
                });
            }
        });
    }

    public void setSelect(boolean sel) {
        int slaveId = -1;
        if (sel && (slaveId = BleSlaveManager.setUserForcusSlave(this.addr)) == -1) {
            System.err.println("MultiListItem  setUserForcusSlave Fail");
        }
        Color backColor = null;
        if (sel && slaveId != -1) {
            backColor = Draw.lightBlueBg;
        }
        this.north.setBackground(backColor);
        this.center.setBackground(backColor);
        this.west.setBackground(backColor);
        this.east.setBackground(backColor);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pn = evt.getPropertyName();
        Object o = evt.getNewValue();
        if (pn.equals("data.broadcast") && o != null) {
            MultimeterReceivedData receivedData = (MultimeterReceivedData)o;
            if (this.addr.equals(receivedData.mAddress)) {
                this.valuelbl.setText(receivedData.ValueString);
                this.funclbl.setText(receivedData.Func);
                this.modelbl.setText(receivedData.Mode);
                this.unitlbl.setText(receivedData.Unit);
            }
        }
    }

    public void switchMulti_SingleLayout(boolean onSingle) {
        if (onSingle) {
            this.doSinglePageLayout();
        } else {
            this.doMultiPageLayout();
        }
    }

    public MultiListItem doMultiPageLayout() {
        this.setMaximumSize(this.itemDim);
        this.titlelbl.setFont(this.titleFt_multi);
        this.valuelbl.setFont(this.valueFt_multi);
        this.funclbl.setFont(this.funcFt_multi);
        this.modelbl.setFont(this.funcFt_multi);
        this.unitlbl.setFont(this.unitFt_multi);
        this.center.setLayout(new FlowLayout());
        this.center.add(this.valuelbl);
        this.repaint();
        return this;
    }

    public MultiListItem doSinglePageLayout() {
        this.setMaximumSize(null);
        this.titlelbl.setFont(this.titleFt_single);
        this.valuelbl.setFont(this.valueFt_single);
        this.funclbl.setFont(this.funcFt_single);
        this.modelbl.setFont(this.funcFt_single);
        this.unitlbl.setFont(this.unitFt_single);
        this.center.setLayout(new BorderLayout());
        this.center.add((Component)this.valuelbl, "Center");
        this.repaint();
        return this;
    }
}

