/*
 * Decompiled with CFR 0.152.
 */
package frame;

import control.MainControl;
import frame.i18n.StringRes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import kernal.BleAgent;
import main.Platform;
import model.DiscoverResult;

public class ScanDialog
extends JDialog
implements PropertyChangeListener {
    private BleAgent ag;
    private MainControl mc;
    private JProgressBar bar;
    private JTable listP;
    private JButton connBtn;
    private List<DiscoverResult> slaveDevs = new ArrayList<DiscoverResult>();
    private static ScanDialog sDlg;

    public static ScanDialog getInstance(JFrame main) {
        if (sDlg == null) {
            sDlg = new ScanDialog(main);
        }
        return sDlg;
    }

    private ScanDialog(JFrame main) {
        super(main);
        this.setSize(new Dimension(500, 299));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                sDlg = null;
            }
        });
        this.initDialog();
        this.ag = Platform.getBle();
        this.mc = Platform.getMain();
        this.ag.broadcast.addProperty(this);
    }

    private void initDialog() {
        this.setTitle(StringRes.getString("scanDlg.title"));
        this.setLayout(new BorderLayout());
        this.createNorthPane();
        this.createListPane();
        this.setVisible(false);
    }

    public void showDlg() {
        this.updateWhenScanBegin();
        this.setVisible(true);
        this.ag.discoveryRequest();
    }

    private void createNorthPane() {
        JPanel northP = new JPanel();
        this.add((Component)northP, "North");
        northP.setLayout(new FlowLayout(2));
        this.connBtn = new JButton(StringRes.getString("scanDlg.connect"));
        northP.add(this.connBtn);
        this.connBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ScanDialog.this.slaveDevs != null) {
                    int row = ScanDialog.this.listP.getSelectedRow();
                    row = row < 0 ? 0 : row;
                    DiscoverResult selDev = (DiscoverResult)ScanDialog.this.slaveDevs.get(row);
                    boolean success = ScanDialog.this.ag.linkRequest(selDev, ((ScanDialog)ScanDialog.this).mc.clientCall);
                    if (!success) {
                        JOptionPane.showMessageDialog(ScanDialog.this, StringRes.getString("scanDlg.hadConnected"));
                    }
                }
            }
        });
        this.bar = new JProgressBar();
        this.bar.setPreferredSize(new Dimension(80, 15));
        this.bar.setOrientation(0);
        this.bar.setIndeterminate(true);
        northP.add(this.bar);
    }

    private void createListPane() {
        this.listP = new JTable(new DefaultTableModel(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getRowCount() {
                return 10;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return " ";
                    }
                    case 1: {
                        return " ";
                    }
                }
                return "";
            }
        });
        this.listP.setRowHeight(35);
        this.listP.getColumnModel().getColumn(0).setPreferredWidth(400);
        JScrollPane scrollP = new JScrollPane(this.listP);
        this.add((Component)scrollP, "Center");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pn = evt.getPropertyName();
        Object o = evt.getNewValue();
        if (o == null) {
            return;
        }
        if (pn.equals("scanDeviceInfo.broadcast")) {
            DiscoverResult r = (DiscoverResult)o;
            boolean hadResult = false;
            for (DiscoverResult res : this.slaveDevs) {
                if (!res.samewith(r)) continue;
                hadResult = true;
            }
            if (!hadResult) {
                this.slaveDevs.add(r);
                int rows = this.slaveDevs.size() - 1;
                this.listP.setValueAt(r, rows, 0);
                this.listP.validate();
            }
        } else if (pn.equals("enableLink.broadcast")) {
            this.updateWhenScanDone();
        }
    }

    private void updateWhenScanDone() {
        this.connBtn.setVisible(true);
        this.bar.setVisible(false);
    }

    private void updateWhenScanBegin() {
        this.connBtn.setVisible(false);
        this.bar.setVisible(true);
    }

    @Deprecated
    private void scanedResultsAddToJTableTest() {
        DiscoverResult a = new DiscoverResult();
        a.addrName = "dev1";
        DiscoverResult b = new DiscoverResult();
        b.addrName = "dev2";
        DiscoverResult[] slaveDevs = new DiscoverResult[]{a, b};
        DefaultTableModel model = (DefaultTableModel)this.listP.getModel();
        int i = 0;
        int l = slaveDevs.length;
        while (i < l) {
            model.setValueAt(slaveDevs[i], i, 0);
            ++i;
        }
        this.listP.validate();
    }

    public static void main(String[] args) {
        ScanDialog d = ScanDialog.getInstance(null);
        d.showDlg();
    }
}

