/*
 * Decompiled with CFR 0.152.
 */
package frame;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import kernal.BleAgent;
import kernal.BleClient;
import main.Platform;
import model.BleClientGattCallback;
import model.BleSlaveManager;
import model.ConnHandleResult;
import model.DiscoverResult;
import model.MultimeterReceivedData;

public class R_Frame
extends Frame
implements PropertyChangeListener {
    TextArea commtxt = new TextArea("order display");
    TextField readtxt = new TextField("show multimeter data here\n");
    BleAgent ag;
    Button btnLink;
    JComboBox discoverResultCcb;
    DiscoverResult[] slaveDevs;
    private BleClientGattCallback clientCall = new BleClientGattCallback(){

        public void onConnectionStateChange(int newState) {
            switch (newState) {
                case 1: {
                    System.err.println(" #######CONNECTED");
                    break;
                }
                case 0: {
                    System.err.println(" DISCONNECTED");
                    break;
                }
            }
        }

        @Override
        public void onCharacteristicRead(int status, byte handle, byte[] value) {
            System.err.println("onRead.handle:" + handle);
            byte[] byArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                System.err.print(String.valueOf(b) + ":");
                ++n2;
            }
            System.err.println();
        }

        @Override
        public void onCharacteristicWrite(int status, byte handle) {
            System.err.println("onWrite.handle:" + handle + ",status:" + status);
        }

        @Override
        public void onCharacteristicChanged(ConnHandleResult tmpConnResult, int status, byte[] data) {
            switch (status) {
                case 2: {
                    System.err.println(" STATE__SUCESS  @  connID:" + tmpConnResult.ConnID + ",addr:" + tmpConnResult.Address);
                    break;
                }
                case 3: {
                    System.err.println(" STATE__ERROR");
                    break;
                }
            }
        }
    };

    public R_Frame() {
        super("PC BLE Multimeter");
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(new BorderLayout());
        this.setVisible(true);
        JPanel north_btnPane = this.initNorthPane();
        JPanel center_Pane = this.initCenterPane();
        JPanel south_btnPane = this.initSouthPane();
        this.add((Component)north_btnPane, "North");
        this.add((Component)center_Pane, "Center");
        this.add((Component)south_btnPane, "South");
        this.ag = Platform.getBle();
        this.ag.broadcast.addProperty(this);
    }

    public void release() {
        this.ag.release();
    }

    public static void main(String[] args) {
        R_Frame R_win = new R_Frame();
        R_win.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        R_win.pack();
    }

    private JPanel initNorthPane() {
        Button btnOpen = new Button("OpenComm");
        btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                R_Frame.this.ag.openSeriesPort();
            }
        });
        Button btnDiscover = new Button("Discover");
        btnDiscover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                R_Frame.this.ag.discoveryRequest();
            }
        });
        this.discoverResultCcb = new JComboBox();
        this.btnLink = new Button("Link");
        this.btnLink.setEnabled(false);
        this.btnLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (R_Frame.this.slaveDevs != null) {
                    DiscoverResult selDev = R_Frame.this.slaveDevs[R_Frame.this.discoverResultCcb.getSelectedIndex()];
                    R_Frame.this.ag.linkRequest(selDev, R_Frame.this.clientCall);
                }
            }
        });
        Button btnTerminate = new Button("Terminate");
        btnTerminate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiscoverResult sel = (DiscoverResult)R_Frame.this.discoverResultCcb.getSelectedItem();
                System.err.println("getItem:" + sel.addrName);
                BleClient client = BleSlaveManager.getClient(sel.addrName);
                R_Frame.this.ag.terminateLinkRequest(client);
            }
        });
        Button btnClear = new Button("Clear");
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                R_Frame.this.commtxt.setText("");
            }
        });
        JPanel north_btnPane = new JPanel();
        north_btnPane.add(btnOpen);
        north_btnPane.add(btnDiscover);
        north_btnPane.add(this.discoverResultCcb);
        north_btnPane.add(this.btnLink);
        north_btnPane.add(btnTerminate);
        north_btnPane.add(btnClear);
        return north_btnPane;
    }

    private JPanel initCenterPane() {
        JPanel centerPane = new JPanel();
        centerPane.setLayout(new BorderLayout());
        centerPane.add((Component)this.commtxt, "Center");
        centerPane.add((Component)this.readtxt, "North");
        return centerPane;
    }

    private JPanel initSouthPane() {
        JPanel south_btnPane = new JPanel();
        JButton holdBtn = new JButton("Light/Hold");
        south_btnPane.add(holdBtn);
        holdBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                byte[] value = new byte[]{3, 1};
                BleClient c = R_Frame.this.ag.getClient();
                if (c != null) {
                    c.writeCharacteristic((byte)43, value);
                }
            }
        });
        JButton selBtn = new JButton("Select");
        south_btnPane.add(selBtn);
        selBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                byte[] value = new byte[]{1, 1};
                BleClient c = R_Frame.this.ag.getClient();
                if (c != null) {
                    c.writeCharacteristic((byte)43, value);
                }
            }
        });
        JButton rangeBtn = new JButton("Range");
        south_btnPane.add(rangeBtn);
        rangeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                byte[] value = new byte[]{2, 1};
                BleClient c = R_Frame.this.ag.getClient();
                if (c != null) {
                    c.writeCharacteristic((byte)43, value);
                }
            }
        });
        JButton hzBtn = new JButton("Hz/Duty");
        south_btnPane.add(hzBtn);
        hzBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                byte[] value = new byte[]{5, 1};
                BleClient c = R_Frame.this.ag.getClient();
                if (c != null) {
                    c.writeCharacteristic((byte)43, value);
                }
            }
        });
        JButton maxminBtn = new JButton("Max/Min");
        south_btnPane.add(maxminBtn);
        maxminBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                byte[] value = new byte[]{6, 1};
                BleClient c = R_Frame.this.ag.getClient();
                if (c != null) {
                    c.writeCharacteristic((byte)43, value);
                }
            }
        });
        JButton relBtn = new JButton("Rel/BLE");
        south_btnPane.add(relBtn);
        relBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                byte[] value = new byte[]{4, 1};
                BleClient c = R_Frame.this.ag.getClient();
                if (c != null) {
                    c.writeCharacteristic((byte)43, value);
                }
            }
        });
        return south_btnPane;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pn = evt.getPropertyName();
        Object o = evt.getNewValue();
        if (pn.equals("data.broadcast") && o != null) {
            MultimeterReceivedData receivedData = (MultimeterReceivedData)o;
            String value = String.valueOf(receivedData.Index) + ". " + receivedData.Func + "  " + receivedData.ValueString + receivedData.Unit;
            this.readtxt.setText(value);
        } else if (pn.equals("interaction.broadcast") && o != null) {
            String msg = (String)o;
            this.commtxt.append(msg);
        } else if (pn.equals("enableLink.broadcast") && o != null) {
            this.slaveDevs = (DiscoverResult[])o;
            this.discoverResultCcb.setModel(new DefaultComboBoxModel<DiscoverResult>(this.slaveDevs));
            this.btnLink.setEnabled(true);
            DiscoverResult[] discoverResultArray = this.slaveDevs;
            int n = this.slaveDevs.length;
            int n2 = 0;
            while (n2 < n) {
                DiscoverResult s = discoverResultArray[n2];
                System.err.println("R_Frame:  " + s);
                ++n2;
            }
            this.pack();
        }
    }
}

