/*
 * Decompiled with CFR 0.152.
 */
package frame;

import control.DeviceInitResultListener;
import frame.i18n.StringRes;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kernal.BleAgent;
import main.Platform;
import storeroom.util.SerialPortUtil;

public class PortSettingDlg
extends JDialog {
    DeviceInitResultListener initListener;
    JComboBox portCbb;

    public PortSettingDlg(DeviceInitResultListener listener) {
        this.initListener = listener;
        this.setSize(new Dimension(300, 250));
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(2);
        this.initDlg();
        new Thread(new Runnable(){

            @Override
            public void run() {
                List<String> list = SerialPortUtil.loadAvailablePort();
                PortSettingDlg.this.portCbb.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            }
        }).start();
        this.setModal(true);
    }

    public void initDlg() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        this.add(p1);
        this.add(p2);
        this.add(p3);
        JLabel portLbl = new JLabel(StringRes.getString("portSettingDlg.port"));
        this.portCbb = new JComboBox();
        this.portCbb.setPreferredSize(new Dimension(150, 25));
        p1.add(portLbl);
        p1.add(this.portCbb);
        JLabel baudLbl = new JLabel(StringRes.getString("portSettingDlg.baud"));
        JComboBox<Integer> baudCbb = new JComboBox<Integer>();
        baudCbb.setPreferredSize(new Dimension(150, 25));
        Integer[] baudArr = new Integer[]{115200, 57600, 38400};
        baudCbb.setModel(new DefaultComboBoxModel<Integer>(baudArr));
        baudCbb.setEnabled(false);
        p2.add(baudLbl);
        p2.add(baudCbb);
        JButton okBtn = new JButton(StringRes.getString("btn.ok"));
        p3.add(okBtn);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectPort = PortSettingDlg.this.portCbb.getSelectedItem().toString();
                PortSettingDlg.this.dispose();
                BleAgent ag = Platform.getBle();
                ag.setUserSelectedPort(selectPort);
                ag.openSeriesPort();
                PortSettingDlg.this.initListener.startListenInitResult();
            }
        });
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new PortSettingDlg(null);
    }
}

