/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.ChartControl;
import frame.MainFrame;
import frame.view.MultiListItem;
import java.util.ArrayList;
import kernal.BleClient;
import model.BleClientGattCallback;
import model.BleSlaveManager;
import model.ConnHandleResult;

public class MainControl {
    private ArrayList<MultiListItem> mits = new ArrayList();
    private ArrayList<MultiListItem> sits = new ArrayList();
    private MainFrame main;
    private ChartControl chartCtr;
    public static final byte selectPress = 1;
    public static final byte rangePress = 2;
    public static final byte holdPress = 3;
    public static final byte relPress = 4;
    public static final byte hzPress = 5;
    public static final byte maxPress = 6;
    public static final byte allPress = 7;
    public static final byte longPress = 0;
    public static final byte pressOnce = 1;
    public BleClientGattCallback clientCall = new BleClientGattCallback(){

        @Override
        public void onConnectionStateChange(String mAddress, int newState) {
            switch (newState) {
                case 1: {
                    System.err.println("#######CONNECTED:  " + mAddress);
                    MainControl.this.onCreateItem(mAddress);
                    MainControl.this.chartCtr.initClientDataModel(BleSlaveManager.getClient(mAddress));
                    break;
                }
                case 0: {
                    System.err.println("#######DISCONNECTED:  " + mAddress);
                    MainControl.this.onPopupItem(mAddress);
                    BleSlaveManager.onPopupClient(BleSlaveManager.getClient(mAddress));
                    MainControl.this.chartCtr.removeSeries(mAddress);
                    break;
                }
            }
        }

        @Override
        public void onCharacteristicRead(int status, byte handle, byte[] value) {
        }

        @Override
        public void onCharacteristicWrite(int status, byte handle) {
        }

        @Override
        public void onCharacteristicChanged(ConnHandleResult tmpConnResult, int status, byte[] data) {
            switch (status) {
                case 2: {
                    break;
                }
                case 3: {
                    System.err.println("MainCtr.onCharacteristicChanged  STATE__ERROR");
                    break;
                }
            }
        }

        @Override
        public void onDeviceSeriesRead(int serieid) {
            MainControl.this.updateCmdBtnsPane();
        }
    };

    public MainControl() {
        this.chartCtr = new ChartControl();
    }

    public MainFrame launchMainFrame() {
        if (this.main == null) {
            this.main = new MainFrame();
        }
        return this.main;
    }

    public ChartControl getChartCtr() {
        return this.chartCtr;
    }

    public void setSelectItem(MultiListItem selected) {
        boolean isone;
        for (MultiListItem it : this.mits) {
            isone = it.addr.equals(selected.addr);
            it.setSelect(isone);
        }
        for (MultiListItem it : this.sits) {
            isone = it.addr.equals(selected.addr);
            it.setSelect(isone);
        }
    }

    public void updateCmdBtnsPane() {
        BleClient mClient = BleSlaveManager.getSelectedClient();
        int seriesId = -1;
        if (mClient != null) {
            seriesId = mClient.getBleSeries().getSeriesID();
        }
        this.main.initSouthPane(seriesId);
    }

    public boolean onCreateItem(String addr) {
        MultiListItem mit = new MultiListItem(this, addr);
        MultiListItem sit = new MultiListItem(this, addr);
        this.mits.add(mit);
        this.sits.add(sit);
        this.main.addItem(mit, sit);
        return true;
    }

    public void onPopupItem(String addr) {
        MultiListItem mit = null;
        MultiListItem sit = null;
        for (MultiListItem it : this.mits) {
            if (!it.addr.equals(addr)) continue;
            this.mits.remove(it);
            mit = it;
            break;
        }
        for (MultiListItem it : this.sits) {
            if (!it.addr.equals(addr)) continue;
            this.sits.remove(it);
            sit = it;
            break;
        }
        this.main.removeItem(mit, sit);
    }

    public static void cWriteCmd(BleClient mClient, byte funcId, boolean isLongPress) {
        if (mClient != null) {
            byte b1 = funcId;
            byte b2 = isLongPress ? (byte)0 : 1;
            byte[] out = new byte[]{b1, b2};
            try {
                Thread.sleep(200L);
                mClient.writeCharacteristic((byte)43, out);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

