/*
 * Decompiled with CFR 0.152.
 */
package checkBLEFunc;

import checkBLEFunc.TransmitBleDialog;
import control.MainControl;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import kernal.BleClient;
import kernal.Event;
import model.BleSlaveManager;
import model.MultimeterReceivedData;
import storeroom.util.ByteUtil;

public class TransmitBleCmdHandler
implements Runnable {
    private static CommPortIdentifier portId;
    private OutputStream outputStream;
    private InputStream inputStream;
    public SerialPort serialPort;
    private Thread handler;
    public boolean onClose;
    public String address;
    TransmitBleDialog.PP p;

    public TransmitBleCmdHandler(String destination, TransmitBleDialog.PP p) {
        this.address = destination;
        this.p = p;
    }

    public void startTransmit(String comName) {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1 || !portId.getName().equals(comName)) continue;
            try {
                this.serialPort = (SerialPort)portId.open("My" + comName, 2000);
            }
            catch (PortInUseException portInUseException) {
                System.err.println("MyComm101 portId.open PortInUseException ");
            }
            try {
                this.outputStream = this.serialPort.getOutputStream();
                this.inputStream = this.serialPort.getInputStream();
            }
            catch (IOException iOException) {
                System.err.println("getOutputStream outputStream ");
            }
            break;
        }
        if (this.serialPort == null) {
            System.err.println("\u93c3\u72b3\u7876\u93b5\u60e7\u57cc\u935a\u5825\ufffd\u509c\ue06c\u9359\ufffd");
            return;
        }
        System.err.println(String.valueOf(this.serialPort.getName()) + "\u6d93\u63d2\u5f5b\u5bb8\u832c\u7ca1\u93b5\u64b3\u7d11,");
        try {
            this.serialPort.setSerialPortParams(9600, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            System.err.println("Set UnsupportedCommOperationException ");
        }
        try {
            this.handler = new Thread(this);
            this.handler.start();
        }
        catch (Exception exception) {}
    }

    @Override
    public void run() {
        while (!this.onClose) {
            block34: {
                try {
                    block35: {
                        int size;
                        byte[] buf;
                        BleClient mClient;
                        block36: {
                            mClient = BleSlaveManager.getClient(this.address);
                            if (mClient == null || !mClient.isConnected()) break block35;
                            buf = ByteUtil.readInputStreamToBuf(this.inputStream);
                            String center_cmd = new String(buf);
                            size = buf.length;
                            if (size <= 1) break block36;
                            if (center_cmd.contains("?")) {
                                List<MultimeterReceivedData> list = mClient.getReceivedData();
                                MultimeterReceivedData rd = list.get(list.size() - 1);
                                String rsp = rd.ValueString;
                                if (center_cmd.equalsIgnoreCase("meas?")) {
                                    rsp = String.valueOf(rd.ValueString) + rd.Unit + "\n";
                                } else if (center_cmd.equalsIgnoreCase("func?")) {
                                    rsp = String.valueOf(rd.Func) + "_" + rd.Range + "\n";
                                } else if (center_cmd.equalsIgnoreCase("data?")) {
                                    rsp = String.valueOf(Event.get2xLink(rd.SourceData)) + "\n";
                                    System.out.println(rsp);
                                }
                                this.outputStream.write(rsp.getBytes());
                                this.outputStream.flush();
                                this.p.updateOutput("value:  " + rsp);
                                System.out.println(rsp);
                                break block34;
                            }
                            int funId = -1;
                            switch (center_cmd) {
                                case "select": {
                                    funId = 1;
                                    break;
                                }
                                case "range": {
                                    funId = 2;
                                    break;
                                }
                                case "hold": {
                                    funId = 3;
                                    break;
                                }
                                case "rel": {
                                    funId = 4;
                                    break;
                                }
                                case "hz": {
                                    funId = 5;
                                    break;
                                }
                                case "max": {
                                    funId = 6;
                                }
                            }
                            MainControl.cWriteCmd(mClient, (byte)funId, false);
                            this.p.updateInput("cmd: " + center_cmd + " ");
                            System.out.println("cmd:" + center_cmd + " ");
                            break block34;
                        }
                        if (size == 1) {
                            byte funId = buf[0];
                            MainControl.cWriteCmd(mClient, funId, false);
                            this.p.updateInput("send: " + funId + " ");
                            System.out.println("send:" + funId + " ");
                        }
                        break block34;
                    }
                    System.out.println(String.valueOf(this.serialPort.getName()) + "\u5a0c\u2103\u6e41\u9483\u6fc8\u58ae\u741b\u3128\u7e5b\u93ba\ufffd");
                    this.p.updateOutput(String.valueOf(this.serialPort.getName()) + "\u5a0c\u2103\u6e41\u9483\u6fc8\u58ae\u741b\u3128\u7e5b\u93ba\ufffd");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("write(data) IOException ");
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

