/*
 * Decompiled with CFR 0.152.
 */
package checkBLEFunc;

import control.MainControl;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JDialog;
import kernal.BleClient;
import model.BleSlaveManager;
import model.MultimeterReceivedData;
import storeroom.util.ByteUtil;

public class CheckBleFrame
extends JDialog
implements Runnable,
ActionListener {
    private static CommPortIdentifier portId;
    private OutputStream outputStream;
    private InputStream inputStream;
    private SerialPort serialPort;
    private Thread readThread;
    Panel btnPane = new Panel();
    TextField in_message = new TextField("");
    TextArea out_message = new TextArea();
    Button btnOpen = new Button("Open Comm101");
    Button btnClose = new Button("Close Comm");
    private byte[] data = new byte[1024];
    boolean onClose = false;
    private static CheckBleFrame frame;

    public static CheckBleFrame getInstance() {
        if (frame == null) {
            frame = new CheckBleFrame();
        }
        return frame;
    }

    private CheckBleFrame() {
        this.setTitle("\u9483\u6fc8\u58ae\u741b\u2252C\u93ba\u0443\u57d7\u93ba\u30e5\u5f5b");
        this.setSize(new Dimension(500, 250));
        this.setVisible(true);
        this.add((Component)this.out_message, "Center");
        this.add((Component)this.btnPane, "North");
        this.add((Component)this.in_message, "South");
        this.btnPane.add(this.btnOpen);
        this.btnPane.add(this.btnClose);
        this.btnOpen.addActionListener(this);
        this.btnClose.addActionListener(this);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CheckBleFrame.this.dispose();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.btnClose) {
            this.btnOpen.setEnabled(true);
            this.onClose = true;
            this.in_message.setText(this.serialPort + "\u6d93\u63d2\u5f5b\u934f\u62bd\u68f4,\u934b\u6ec4\ue11b\u9359\u6226\ufffd\u4f79\u669f\u93b9\ufffd.");
            this.serialPort.close();
        } else {
            this.btnOpen.setEnabled(false);
            this.onClose = false;
            this.start();
        }
    }

    public void start() {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            if (portId.getName().equals("COM101")) {
                try {
                    this.serialPort = (SerialPort)portId.open("MyComm101", 2000);
                }
                catch (PortInUseException portInUseException) {
                    System.err.println("MyComm101 portId.open PortInUseException ");
                }
                try {
                    this.outputStream = this.serialPort.getOutputStream();
                    this.inputStream = this.serialPort.getInputStream();
                }
                catch (IOException iOException) {
                    System.err.println("getOutputStream outputStream ");
                }
                break;
            }
            System.out.println(portId.getName());
        }
        if (this.serialPort == null) {
            this.in_message.setText("\u93c3\u72b3\u7876\u93b5\u60e7\u57cc\u935a\u5825\ufffd\u509c\ue06c\u9359\ufffd");
            return;
        }
        this.in_message.setText(String.valueOf(this.serialPort.getName()) + "\u6d93\u63d2\u5f5b\u5bb8\u832c\u7ca1\u93b5\u64b3\u7d11,");
        try {
            this.serialPort.setSerialPortParams(9600, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            System.err.println("Set UnsupportedCommOperationException ");
        }
        try {
            this.readThread = new Thread(this);
            this.readThread.start();
        }
        catch (Exception exception) {}
    }

    @Override
    public void run() {
        while (!this.onClose) {
            block28: {
                try {
                    block29: {
                        String center_cmd;
                        block30: {
                            BleClient mClient = BleSlaveManager.getSelectedClient();
                            if (mClient == null || !mClient.isConnected()) break block29;
                            byte[] buf = ByteUtil.readInputStreamToBuf(this.inputStream);
                            center_cmd = new String(buf);
                            int size = buf.length;
                            if (size > 0 && center_cmd.equalsIgnoreCase("meas?")) {
                                List<MultimeterReceivedData> list = mClient.getReceivedData();
                                MultimeterReceivedData rd = list.get(list.size() - 1);
                                this.outputStream.write(rd.ValueString.getBytes());
                                this.outputStream.flush();
                                this.out_message.setText(rd.ValueString);
                                System.out.println(rd.ValueString);
                                break block28;
                            }
                            if (size <= 0 || center_cmd.contains("?")) break block30;
                            byte funId = -1;
                            switch (center_cmd) {
                                case "select": {
                                    funId = 1;
                                    break;
                                }
                                case "range": {
                                    funId = 2;
                                    break;
                                }
                                case "hold": {
                                    funId = 3;
                                    break;
                                }
                                case "rel": {
                                    funId = 4;
                                    break;
                                }
                                case "hz": {
                                    funId = 5;
                                    break;
                                }
                                case "max": {
                                    funId = 6;
                                }
                            }
                            System.err.println("funId:" + funId);
                            MainControl.cWriteCmd(mClient, funId, false);
                            this.in_message.setText(this.serialPort + ":" + center_cmd + " send");
                            System.out.println(this.serialPort + ":" + center_cmd + " send");
                            break block28;
                        }
                        this.in_message.setText(this.serialPort + ":" + center_cmd + " ,can`t recognize");
                        break block28;
                    }
                    this.in_message.setText(String.valueOf(this.serialPort.getName()) + "\u5a0c\u2103\u6e41\u9483\u6fc8\u58ae\u741b\u3128\u7e5b\u93ba\ufffd,");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("write(data) IOException ");
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        CheckBleFrame f = new CheckBleFrame();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.pack();
    }
}

